% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dl.R
\name{dl_stats19}
\alias{dl_stats19}
\title{Download STATS19 data for a year}
\usage{
dl_stats19(
  year = NULL,
  type = NULL,
  data_dir = get_data_directory(),
  file_name = NULL,
  ask = FALSE,
  silent = FALSE,
  timeout = 600
)
}
\arguments{
\item{year}{A year matching file names on the STATS19
\href{https://www.data.gov.uk/dataset/cb7ae6f0-4be6-4935-9277-47e5ce24a11f/road-accidents-safety-data}{data release page}
e.g. \code{2020}}

\item{type}{One of 'collision', 'casualty', 'Vehicle'; defaults to 'collision'.
This text string is used to match the file names released by the DfT.}

\item{data_dir}{Parent directory for all downloaded files. See \code{\link[=get_data_directory]{get_data_directory()}} for details.}

\item{file_name}{The file name (DfT named) to download.}

\item{ask}{Should you be asked whether or not to download the files? \code{TRUE} by default.}

\item{silent}{Boolean. If \code{FALSE} (default value), display useful progress
messages on the screen.}

\item{timeout}{Timeout in seconds for the download if current option is less than
this value. Defaults to 600 (10 minutes).}
}
\description{
Download STATS19 data for a year
}
\section{Details}{

This function downloads UK road crash data.
It results in .csv files that are put
in a directory that can be set with \code{\link[=get_data_directory]{get_data_directory()}}.
By default, stats19 downloads files to a temporary directory.
You can change this behavior to save the files in a permanent directory.
This is done by setting the \code{STATS19_DOWNLOAD_DIRECTORY} environment variable.
A convenient way to do this is by adding \verb{STATS19_DOWNLOAD_DIRECTORY=/path/to/a/dir}
to your \code{.Renviron} file, which can be opened with \code{usethis::edit_r_environ()}.

The file downloaded would be for a specific year (e.g. 2022).
It could also be a file containing data for a range of two (e.g. 2005-2014).

The \verb{dl_*} functions can download many MB of data so ensure you
have a sufficient internet access and hard disk space.
}

\examples{
\donttest{
if (curl::has_internet()) {
  # type by default is collisions table
  dl_stats19(year = 2022)
  # with type as casualty
  dl_stats19(year = 2022, type = "casualty")
  # try another year
  dl_stats19(year = 2023)
}
}
}
\seealso{
\code{\link[=get_stats19]{get_stats19()}}
}
