% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_chr_ish.R
\name{are_chr_ish}
\alias{are_chr_ish}
\alias{is_chr_ish}
\alias{are_chr_ish.default}
\title{Check if an object can be safely coerced to character}
\usage{
are_chr_ish(x, ...)

is_chr_ish(x, ...)

\method{are_chr_ish}{default}(x, ..., depth = 1)
}
\arguments{
\item{x}{The object to check.}

\item{...}{Arguments passed to methods.}

\item{depth}{\verb{(length-1 integer)} Current recursion depth. Do not manually
set this parameter.}
}
\value{
\code{are_chr_ish()} returns a logical vector with the same length as the
input. \code{is_chr_ish()} returns a \verb{length-1 logical} (\code{TRUE} or \code{FALSE}) for
the entire vector.
}
\description{
\code{are_chr_ish()} is a vectorized predicate function that checks whether each
element of its input can be safely coerced to a character vector.

\code{is_chr_ish()} is a scalar predicate function that checks if all elements of
its input can be safely coerced to a character vector.
}
\examples{
are_chr_ish(letters)
is_chr_ish(letters)

are_chr_ish(1:10)
is_chr_ish(1:10)

are_chr_ish(list("a", 1, TRUE))
is_chr_ish(list("a", 1, TRUE))

are_chr_ish(list("a", 1, list(1, 2)))
is_chr_ish(list("a", 1, list(1, 2)))
}
