% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_int.R, R/to_int.R
\name{stabilize_int}
\alias{stabilize_int}
\alias{stabilize_int_scalar}
\alias{to_int}
\alias{to_int.NULL}
\alias{to_int.character}
\alias{to_int.factor}
\alias{to_int_scalar}
\title{Ensure an integer argument meets expectations}
\usage{
stabilize_int(
  x,
  ...,
  allow_null = TRUE,
  allow_na = TRUE,
  coerce_character = TRUE,
  coerce_factor = TRUE,
  min_size = NULL,
  max_size = NULL,
  min_value = NULL,
  max_value = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

stabilize_int_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  allow_na = TRUE,
  coerce_character = TRUE,
  coerce_factor = TRUE,
  min_value = NULL,
  max_value = NULL,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_int(
  x,
  ...,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

\method{to_int}{`NULL`}(x, ..., allow_null = TRUE, x_arg = caller_arg(x), call = caller_env())

\method{to_int}{character}(
  x,
  ...,
  coerce_character = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

\method{to_int}{factor}(
  x,
  ...,
  coerce_factor = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)

to_int_scalar(
  x,
  ...,
  allow_null = TRUE,
  allow_zero_length = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{...}{Arguments passed to methods.}

\item{allow_null}{\verb{(length-1 logical)} Is NULL an acceptable value?}

\item{allow_na}{\verb{(length-1 logical)} Are NA values ok?}

\item{coerce_character}{\verb{(length-1 logical)} Should character vectors such as
"1" and "2.0" be considered numeric-ish?}

\item{coerce_factor}{\verb{(length-1 logical)} Should factors with values such as
"1" and "2.0" be considered numeric-ish? Note that this package uses the
character value from the factor, while \code{\link[=as.integer]{as.integer()}} and \code{\link[=as.double]{as.double()}} use
the integer index of the factor.}

\item{min_size}{\verb{(length-1 integer)} The minimum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{max_size}{\verb{(length-1 integer)} The maximum size of the object. Object
size will be tested using \code{\link[vctrs:vec_size]{vctrs::vec_size()}}.}

\item{min_value}{\verb{(length-1 numeric)} The lowest allowed value for \code{x}. If
\code{NULL} (default) values are not checked.}

\item{max_value}{\verb{(length-1 numeric)} The highest allowed value for \code{x}. If
\code{NULL} (default) values are not checked.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}

\item{allow_zero_length}{\verb{(length-1 logical)} Are zero-length vectors
acceptable?}
}
\value{
The argument as an integer.
}
\description{
\code{to_int()} checks whether an argument can be coerced to integer
without losing information, returning it silently if so. Otherwise an
informative error message is signaled.

\code{stabilize_int()} can check more details about the argument, but is slower
than \code{to_int()}.

\code{stabilize_int_scalar()} and \code{to_int_scalar()} are optimized to check for
length-1 integer vectors.
}
\examples{
to_int(1:10)
to_int("1")
to_int(1 + 0i)
to_int(NULL)
try(to_int(c(1, 2, 3.1, 4, 5.2)))
try(to_int("1", coerce_character = FALSE))
try(to_int(c("1", "2", "3.1", "4", "5.2")))

to_int_scalar("1")
try(to_int_scalar(1:10))

stabilize_int(1:10)
stabilize_int("1")
stabilize_int(1 + 0i)
stabilize_int(NULL)
try(stabilize_int(NULL, allow_null = FALSE))
try(stabilize_int(c(1, NA), allow_na = FALSE))
try(stabilize_int(letters))
try(stabilize_int("1", coerce_character = FALSE))
try(stabilize_int(factor(c("1", "a"))))
try(stabilize_int(factor("1"), coerce_factor = FALSE))
try(stabilize_int(1:10, min_value = 3))
try(stabilize_int(1:10, max_value = 7))

stabilize_int_scalar(1L)
stabilize_int_scalar("1")
try(stabilize_int_scalar(1:10))
stabilize_int_scalar(NULL)
try(stabilize_int_scalar(NULL, allow_null = FALSE))
}
