# Stencila Schema for R

[![Build Status](https://dev.azure.com/stencila/stencila/_apis/build/status/stencila.schema?branchName=master)](https://dev.azure.com/stencila/stencila/_build/latest?definitionId=9&branchName=master)
[![Code coverage](https://badger.nokome.now.sh/codecov-folder/stencila/schema/R)](https://codecov.io/gh/stencila/schema/tree/master/R)
[![CRAN](https://www.r-pkg.org/badges/version-last-release/schema)](https://CRAN.R-project.org/package=stencilaschema)
[![Docs](https://img.shields.io/badge/docs-latest-blue.svg)](https://stencila.github.io/schema/r/docs/)

This package provides R bindings for the [Stencila Schema](https://schema.stenci.la). It is primarily aimed at R developers wanting to programmatically generate, or modify, executable documents. For example, it is used in [`rasta`](https://github.com/stencila/rasta), a Stencila plugin for R.

## Install

This package isn't on CRAN yet, but you can install it directly from this repository using the [`remotes`](https://github.com/r-lib/remotes) package,

```r
remotes::install_github("stencila/schema", subdir = "r", upgrade = "ask")
```

## Use

This package exports a factory function for each type of document node in the Stencila Schema e.g. `Article`, `Paragraph`, `CodeChunk`.

For example,

```r
chunk <- CodeChunk(
  text = "SELECT * FROM data",
  programmingLanguage = "sql"
)
> names(chunk)
[1] "type"                "text"                "programmingLanguage"
> chunk$type
[1] "CodeChunk"
attr(,"class")
[1] "scalar"    "character"
```

Note that the `type` property is set automatically. The `class` of the node also includes the full hierarchy of ancestor types, so you can use the `inherits` function as needed:

```r
> class(chunk)
[1] "list"      "Entity"    "Code"      "CodeBlock" "CodeChunk"
> inherits(chunk, "CodeChunk")
[1] TRUE
> inherits(chunk, "Code")
[1] TRUE
> inherits(chunk, "Pizza")
[1] FALSE
```

Each constructor function checks that the arguments provided conform to the Schema. For example,

```r
# Wrong type for a property supplied
Article(
  authors = Paragraph('My article title')
)
Error: CreativeWork$authors is type Paragraph, expected type Array(Union(Person, Organization))

# Required property not supplied
Article(
  authors = list(Person(givenNames = 'John',  familyNames = 'Smith'))
)
Error: Article$title is required

# Success!
Article(
  authors = list(Person(givenNames = 'John',  familyNames = 'Smith')),
  title = 'My article title'
)
```

## Develop

Get started by cloning this repository,

```bash
git clone git@github.com:stencila/schema
cd schema/r
```

Most development tasks can be run from R, using `make` shortcuts, or RStudio keyboard shortcuts.

| Task                             | `make`          | R/RStudio                             |
| -------------------------------- | --------------- | ------------------------------------- |
| Install development dependencies | `make setup`    |
| Regenerate `R/types.R`           | `make regen`    |
| Run linting                      | `make lint`     | `lintr::lint_package()`               |
| Run tests                        | `make test`     | `devtools::test()` or `Ctrl+Shift+T`  |
| Re-run tests on changes          | `make autotest` | `testthat::auto_test_package()`       |
| Run tests with coverage          | `make cover`    | `covr::package_coverage()`            |
| Build documentation              | `make docs`     | `devtools::document()`                |
| Check the package                | `make check`    | `Ctrl+Shift+E`                        |
| Build the package                | `make build`    | `devtools::build()` or `Ctrl+Shift+B` |
| Clean                            | `make clean`    |

### Testing

Unit tests live in the `tests` folder and are written using `testthat`.

### Documentation

Documentation is written using `roxygen2` and the documentation site is generated by `pkgdown` into the `docs` folder and published on GitHub pages.

### Continuous integration

Tests are run on [Azure Pipelines](https://dev.azure.com/stencila/stencila/_build/latest?definitionId=9&branchName=master) and code coverage tracked at [Codecov](https://codecov.io/gh/stencila/schema).
