% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.r
\name{StepPenal}
\alias{StepPenal}
\title{Stepwise forward variable selection using penalized regression.}
\usage{
StepPenal(Data, lamda, w, standardize = TRUE)
}
\arguments{
\item{Data}{should have the following structure: the first column must be the binary response variable y.}

\item{lamda}{the tuning penalty parameter}

\item{w}{the weight parameter for the sum (1-w)L0+ wL1}

\item{standardize}{Logical flag for the predictors' standardization, prior to fitting the model.
Default is standardize=TRUE}
}
\value{
a list with the shrinked coefficients and the names of the selected variables, i.e those variables with
an estimated coefficient different from zero. It also returns the value of the objective function, evaluated for the
values of the coefficients.
}
\description{
Stepwise forward variable selection based on the combination of L1 and L0 penalties.
The optimization is done using the "BFGS" method in stats::optim
}
\details{
lamda and w  parameters need to be tuned by cross-Validation using stepPenal::tuneParam
}
\examples{
# use the StepPenal function on a simulated dataset, with given lamda and w.

set.seed(14)
beta    <- c(3, 2, -1.6, -1)
noise   <- 5
simData <- SimData(N=100, beta=beta, noise=noise, corr=FALSE)
\dontrun{
before <- Sys.time()
stepPenal<- StepPenal(Data=simData, lamda=1.5, w=0.3)
after <- Sys.time()
after-before

(varstepPenal<- stepPenal$coeffP)
}
}
\references{
Vradi E, Brannath W, Jaki T, Vonk R. Model selection based on combined penalties for biomarker
identification. Journal of biopharmaceutical statistics. 2018 Jul 4;28(4):735-49.
}
\seealso{
\code{\link[stats]{optim}}
}
