% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepdown.R
\name{fdp_sd}
\alias{fdp_sd}
\title{Convert winning scores and labels into discoveries}
\usage{
fdp_sd(
  scores_and_labels,
  alpha,
  conf,
  c = 0.5,
  lambda = 0.5,
  procedure = "standard"
)
}
\arguments{
\item{scores_and_labels}{An m x 2 matrix obtained via \code{mirandom}.}

\item{alpha}{An FDP threshold.}

\item{conf}{To control the FDP with \code{1 - conf} confidence.}

\item{c}{Determines the ranks of the target score that are considered
winning. Defaults to \code{c = 0.5} for single-decoy FDP-SD.}

\item{lambda}{Determines the ranks of the target score that are
considered losing. Defaults to \code{lambda = 0.5} for single-decoy FDP-SD.}

\item{procedure}{Takes a value of "standard" (for non-randomised FDP-SD) or
"coinflip" (for randomised FDP-SD).}
}
\value{
A list of 2 objects: the winning scores (\code{discoveries}) and
indices (\code{discoveries_ind}) of rejected hypotheses.
}
\description{
\code{fdp_sd} takes the output of \code{mirandom} and additional
statistical parameters to return the indices and winning scores of
hypotheses that were rejected.
}
\examples{
set.seed(123)
target_scores <- rnorm(200, mean = 1.5)
decoy_scores <- matrix(rnorm(600, mean = 0), ncol = 3)
scores <- cbind(target_scores, decoy_scores)
scores_and_labels <- mirandom(scores)
fdp_sd(scores_and_labels, alpha = 0.1, conf = 0.1)
}
