% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STLHinhom.R
\name{STLHinhom}
\alias{STLHinhom}
\title{Inhomogeneous nearest neighbour function for spatio-temporal point processes on linear networks}
\usage{
STLHinhom(X,
lambda = NULL,
r = NULL,
t = NULL,
nxy = 10)
}
\arguments{
\item{X}{a spatio-temporal point pattern of class \code{\link{stlpp}}}

\item{lambda}{values of estimated intensity at data points}

\item{r}{values of argument r where pair correlation function will be evaluated. optional}

\item{t}{values of argument t where pair correlation function will be evaluated. optional}

\item{nxy}{pixel array dimensions. optional}
}
\value{
An object of class \code{sumstlpp}.
}
\description{
This function computes the inhomogeneous nearest neighbour function for spatio-temporal point processes on linear networks.
}
\details{
This function calculates the inhomogeneous nearest neighbour function for a spatio-temporal point patterns on a linear network.
}
\examples{
\dontrun{
X <- rpoistlpp(0.2, a = 0, b = 5, L = easynet)
lambda <- density(X, at = "points")
h <- STLHinhom(X, lambda = lambda)
}


}
\references{
Moradi, M., & Sharifi, A. (2024). Summary statistics for spatio-temporal point processes on linear networks. Spatial Statistics, 61, 100840.
}
\seealso{
\code{\link{STLFinhom}}, \code{\link{STLKinhom}}, \code{\link{STLginhom}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
