% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvmp.R
\name{rtraj.vmp}
\alias{rtraj.vmp}
\title{Simulate von Mises process}
\usage{
rtraj.vmp(n, theta_0, dt, mu, lambda, sigma)
}
\arguments{
\item{n}{number of steps in the simulated path}

\item{theta_0}{initial point}

\item{dt}{Time step}

\item{mu}{mean parameter}

\item{lambda}{drift parameter}

\item{sigma}{volatility parameter}
}
\value{
A vector of length \code{n} of the simulated path from von Mises process
}
\description{
\code{rtraj.vmp} returns a simulated path of a von Mises process for given parameters
}
\details{
Let \eqn{\theta_t} evolve according to a von Mises process given by,
\deqn{d\theta_t=-\lambda\sin(\theta_t-\mu)dt+\sigma dW_t}

We simulate \eqn{\theta_t} by the Euler-Maruyama discretization of the above SDE.
}
