% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochcorr_sim.R
\name{stochcorr.sim}
\alias{stochcorr.sim}
\title{Simulate stochastic correlation model}
\usage{
stochcorr.sim(m=500, n, dt, S1_0, S2_0, mu1, sigma1, mu2, sigma2,
mu, lambda, sigma, corr_process)
}
\arguments{
\item{m}{number of paths (Default is 500)}

\item{n}{number of steps in each simulated path}

\item{dt}{time step}

\item{S1_0}{initial price of the first asset}

\item{S2_0}{initial price of the second asset}

\item{mu1}{drift of the first asset}

\item{sigma1}{volatility of the first asset}

\item{mu2}{drift of the second asset}

\item{sigma2}{volatility of the second asset}

\item{mu}{mean direction of the correlation process (if \code{corr_process=vmp})}

\item{lambda}{drift of the correlation process (if \code{corr_process=vmp})}

\item{sigma}{volatility of the correlation process (if \code{corr_process=vmp} or \code{corr_process=cbm})}

\item{corr_process}{specify the correlation process, \code{vmp} for von Mises process or \code{cbm} for Circular Brownian Motion}
}
\value{
Returns a list with prices of two assets \code{S1} and \code{S2} under the stochastic correlation model
}
\description{
\code{stochcorr.sim} returns the paths of stock price under a stochastic correlation model
}
\details{
This function returns the simulated paths of two stock prices following a stochastic correlation model. See \code{\link[=stochcorr]{stochcorr()}}
details of the stochastic correlation model
}
\examples{
library(stochcorr)
# Generate 500 paths of two geometric Brownian motions, S1 and S2, of length 100 each
# following the von Mises process with mu=pi/2, lambda=1 and sigma =1

a<-stochcorr.sim(m=500,100,0.01,100,100,0.05,0.05,0.06,0.1,pi/2,1,1,"vmp")
t<-seq(0,100*0.01-0.01,0.01)

# Plot the first realization of S1 and S2

plot(t,a$S1[1,], ylim=c(min(a$S1[1,],a$S2[1,]),max(a$S1[1,],a$S2[1,])),type="l")
lines(t,a$S2[1,], col="red",type="l")
legend(0.01,max(a$S1[1,],a$S2[1,]), legend = c("S1","S2"), col = c("black", "red"), lty=1)

}
