% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{mcmc_stpp_nonunif}
\alias{mcmc_stpp_nonunif}
\title{Bayesian Estimation of Spatio-Temporal Hawkes Model Parameters with non uniform spatial locations}
\usage{
mcmc_stpp_nonunif(
  data,
  poly,
  t_max = max(data$t),
  t_mis = NULL,
  param_init = NULL,
  mcmc_param = NULL,
  branching = TRUE,
  print = TRUE,
  sp_clip = TRUE
)
}
\arguments{
\item{data}{- A DataFrame containing \eqn{x},\eqn{y},\eqn{t}}

\item{poly}{- matrix defining polygon (\eqn{N} x \eqn{2})}

\item{t_max}{- maximum time value (default = max(times))}

\item{t_mis}{- vector of two elements describing missing time range (default = `NULL`)}

\item{param_init}{- list of parameters of initial guess (default = `NULL`, will start with MLE)}

\item{mcmc_param}{- list of mcmc parameters}

\item{branching}{- using branching structure in estimation (default = `TRUE`)}

\item{print}{- print progress (default = `TRUE`)}

\item{sp_clip}{- when simulating missing data spatial points, clip spatial region back to observed region (default = `TRUE`)}
}
\value{
A List containing the mcmc samples (samps), branching structure (`y`, if `TRUE`), and missing data (`zsamps` if `t_mis` is not `NULL`)
If `t_mis` is not `NULL` the mcmc samples will contain `n_missing`, the number of missing points estimated
}
\description{
This function computes the posterior of a spatio-temporal exponential decay Hawkes model
using Metropolis-with-in-Gibbs sampling.
}
\details{
The default is to estimate the branching structure.
The model will also account to missing data if \code{t_mis} is provided.
}
