% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms_of_other_authors.R
\name{SimpleGreedy}
\alias{SimpleGreedy}
\alias{SimpleGreedy2}
\title{Integer-valued Optimal Univariate Allocation Under Constraints for Stratified
Sampling}
\usage{
SimpleGreedy(
  n,
  Ah,
  mh = rep(1, length(Ah)),
  Mh = rep(Inf, length(Ah)),
  nh = mh
)

SimpleGreedy2(v0, Nh, Sh, mh = rep(1, length(Nh)), Mh = Nh, nh = mh)
}
\arguments{
\item{n}{\itemize{
\item target sample size for allocation.
}}

\item{Ah}{\itemize{
\item population strata sizes * standard deviations of a given variable in strata.
}}

\item{mh}{\itemize{
\item lower constraints for sample sizes in strata.
}}

\item{Mh}{\itemize{
\item upper constraints for sample sizes in strata.
}}

\item{nh}{\itemize{
\item initial allocation (if not given then nh=mh).
}}

\item{v0}{\itemize{
\item upper limit for value of variance which must be attained for
computed optimal allocation.
}}

\item{Nh}{\itemize{
\item population strata sizes.
}}

\item{Sh}{\itemize{
\item standard deviations of a given variable in strata.
}}
}
\value{
A vector of optimal allocation sizes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Simple algorithm from paper Friedrich et al. (2015) for integer-valued
optimal allocation in stratified sampling.
}
\section{Functions}{
\itemize{
\item \code{SimpleGreedy2()}: 

}}
\references{
Friedrich, U., Münnich, R., de Vries, S. and Wagner, M. (2015)
Fast integer-valued algorithms for optimal allocations under constraints in
stratified sampling,
\emph{Computational Statistics and Data Analysis}, 92, pp. 1–12.
\url{https://www.sciencedirect.com/science/article/pii/S0167947315001413}
}
