% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSClassifier_MOA.R
\name{DSClassifier_MOA}
\alias{DSClassifier_MOA}
\alias{update.DSClassifier_MOA}
\alias{predict.DSClassifier_MOA}
\title{DSClassifier_MOA -- MOA-based Stream Classifiers}
\usage{
DSClassifier_MOA(formula, RMOA_classifier)

\method{update}{DSClassifier_MOA}(object, dsd, n = 1, verbose = FALSE, block = 1000L, ...)

\method{predict}{DSClassifier_MOA}(object, newdata, type = "response", ...)
}
\arguments{
\item{formula}{a formula for the classification problem.}

\item{RMOA_classifier}{a \code{RMOA_classifier} object.}

\item{object}{a DSC object.}

\item{dsd}{a data stream object.}

\item{n}{number of data points taken from the stream.}

\item{verbose}{logical; show progress?}

\item{block}{process blocks of data to improve speed.}

\item{...}{further arguments.}

\item{newdata}{dataframe with the new data.}

\item{type}{prediction type (see \code{\link[RMOA:predict.MOA_trainedmodel]{RMOA::predict.MOA_trainedmodel()}}).}
}
\value{
An object of class \code{DSClassifier_MOA}
}
\description{
Interface for MOA-based stream classification methods based on package \pkg{RMOA}.
}
\details{
\code{DSClassifier_MOA} provides an interface to MOA-based stream classifiers using package
\pkg{RMOA}. RMOA provides access to MOAs stream classifiers in the following groups:
\itemize{
\item \link[RMOA:MOA_classification_trees]{RMOA::MOA_classification_trees}
\item \link[RMOA:MOA_classification_bayes]{RMOA::MOA_classification_bayes}
\item \link[RMOA:MOA_classification_ensemblelearning]{RMOA::MOA_classification_ensemblelearning}
}

Subsequent calls to \code{update()} update the current model.
}
\examples{
\dontrun{
library(streamMOA)
library(RMOA)

# create a data stream for the iris dataset
data <- iris[sample(nrow(iris)), ]
stream <- DSD_Memory(data)
stream

# define the stream classifier. MOAmodelOptions can be passed on as a control parameter
#   to the call RMOA::HoeffdingTree(). See ? RMOA::MOAoptions
cl <- DSClassifier_MOA(
  Species ~ Sepal.Length + Sepal.Width + Petal.Length,
  RMOA::HoeffdingTree()
  )

cl

# update the classifier with 100 points from the stream
update(cl, stream, 100)

# look at the classifier RMOA object
cl$RMOAObj

# predict the class for the next 50 points
newdata <- get_points(stream, n = 50)
pr <- predict(cl, newdata)
pr

table(pr, newdata$Species)
}
}
\references{
Wijffels, J. (2014) Connect R with MOA to perform streaming
classifications. https://github.com/jwijffels/RMOA

Bifet A, Holmes G, Pfahringer B, Kranen P, Kremer H, Jansen T, Seidl T
(2010).  MOA: Massive Online Analysis, a Framework for Stream Classification
and Clustering. \emph{Journal of Machine Learning Research (JMLR)}.
}
\author{
Michael Hahsler
}
\concept{DSClassifier_MOA}
