% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSRegressor_MOA.R
\name{DSRegressor_MOA}
\alias{DSRegressor_MOA}
\alias{update.DSRegressor_MOA}
\alias{predict.DSRegressor_MOA}
\title{DSRegressor_MOA -- MOA-based Stream Regressors}
\usage{
DSRegressor_MOA(formula, RMOA_regressor)

\method{update}{DSRegressor_MOA}(object, dsd, n = 1, verbose = FALSE, block = 1000L, ...)

\method{predict}{DSRegressor_MOA}(object, newdata, type = "response", ...)
}
\arguments{
\item{formula}{a formula for the regression problem.}

\item{RMOA_regressor}{a \code{RMOA_regressors} object.}

\item{object}{a DSC object.}

\item{dsd}{a data stream object.}

\item{n}{number of data points taken from the stream.}

\item{verbose}{logical; show progress?}

\item{block}{process blocks of data to improve speed.}

\item{...}{further arguments.}

\item{newdata}{dataframe with the new data.}

\item{type}{prediction type (see \code{\link[RMOA:predict.MOA_trainedmodel]{RMOA::predict.MOA_trainedmodel()}}).}
}
\value{
An object of class \code{DSRegressor_MOA}
}
\description{
Interface for MOA-based stream regression methods based on package \pkg{RMOA}.
}
\details{
\code{DSRegressor_MOA} provides an interface to MOA-based stream regressors using package
\pkg{RMOA}. Available regressors can be found at \link[RMOA:MOA_regressors]{RMOA::MOA_regressors}.

Subsequent calls to \code{update()} update the current model.
}
\examples{
\dontrun{
library(streamMOA)
library(RMOA)

# create a data stream for the iris dataset
data <- iris[sample(nrow(iris)), ]
stream <- DSD_Memory(data)
stream

# define a stream regression model.
cl <- DSRegressor_MOA(
  Sepal.Length ~ Species + Sepal.Width + Petal.Length,
  RMOA::Perceptron()
  )

cl

# update the model with 100 points from the stream
update(cl, stream, 100)

# look at the RMOA model object
cl$RMOAObj

# make predictions for the next 50 points
newdata <- get_points(stream, n = 50)
pr <- predict(cl, newdata)
pr

plot(pr, newdata$Sepal.Length, xlim = c(0,10), ylim = c(0,10))
abline(a = 0, b = 1, col = "red")
}
}
\references{
Wijffels, J. (2014) Connect R with MOA to perform streaming
classifications. https://github.com/jwijffels/RMOA

Bifet A, Holmes G, Pfahringer B, Kranen P, Kremer H, Jansen T, Seidl T
(2010).  MOA: Massive Online Analysis, a Framework for Stream Classification
and Clustering. \emph{Journal of Machine Learning Research (JMLR)}.
}
\author{
Michael Hahsler
}
\concept{DSRegressor_MOA}
