% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_Target.R
\name{DSD_Target}
\alias{DSD_Target}
\title{Target Data Stream Generator}
\usage{
DSD_Target(
  center_sd = 0.05,
  center_weight = 0.5,
  ring_r = 0.2,
  ring_sd = 0.02,
  noise = 0
)
}
\arguments{
\item{center_sd}{standard deviation of center}

\item{center_weight}{proportion of points in center}

\item{ring_r}{average ring radius}

\item{ring_sd}{standard deviation of ring radius}

\item{noise}{proportion of noise}
}
\value{
Returns a \code{DSD_Target} object.
}
\description{
A data stream generator that generates a data stream in the shape of a
target. It has a single Gaussian cluster in the center and a ring that
surrounds it.
}
\details{
This DSD will produce a singular Gaussian cluster in the center with a ring around
it.
}
\examples{
# create data stream with three clusters in 2D
stream <- DSD_Target()

get_points(stream, n = 5)

plot(stream)
}
\seealso{
Other DSD: 
\code{\link{DSD}()},
\code{\link{DSD_BarsAndGaussians}()},
\code{\link{DSD_Benchmark}()},
\code{\link{DSD_Cubes}()},
\code{\link{DSD_Gaussians}()},
\code{\link{DSD_MG}()},
\code{\link{DSD_Memory}()},
\code{\link{DSD_Mixture}()},
\code{\link{DSD_NULL}()},
\code{\link{DSD_ReadDB}()},
\code{\link{DSD_ReadStream}()},
\code{\link{DSD_UniformNoise}()},
\code{\link{DSD_mlbenchData}()},
\code{\link{DSD_mlbenchGenerator}()},
\code{\link{DSF}()},
\code{\link{animate_data}()},
\code{\link{close_stream}()},
\code{\link{get_points}()},
\code{\link{plot.DSD}()},
\code{\link{reset_stream}()}
}
\author{
Michael Hahsler
}
\concept{DSD}
