% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlm_regressor.R
\name{mlm_regressor}
\alias{mlm_regressor}
\title{Fit Machine Learning Regressor Models}
\usage{
mlm_regressor(
  formula,
  train_data,
  fit_models = c("ada", "et", "lightgbm", "gbr", "lr", "rf", "ridge", "knn", "dt",
    "dummy", "lar", "br", "huber", "omp", "lasso", "en", "llar", "par"),
  sort_v = c("MAE", "MSE", "RMSE", "R2", "RMSLE", "MAPE"),
  n_models = 9999,
  seed = NULL,
  ...
)
}
\arguments{
\item{formula}{A linear formula object.}

\item{train_data}{A data.frame object that includes data to be trained on.}

\item{fit_models}{A character vector with all the possible Machine Learning
regressors that are currently being fit. The user may specify a subset of
them using a character vector.
\tabular{rl}{
  ada \tab AdaBoost Regressor \cr
  br \tab Bayesian Ridge \cr
  dt \tab Decision Tree Regressor \cr
  dummy \tab Dummy Regressor \cr
  en \tab Elastic Net \cr
  et \tab Extra Trees Regressor \cr
  gbr \tab Gradient Boosting Regressor \cr
  huber \tab Huber Regressor \cr
  knn \tab K Neighbors Regressor \cr
  lar \tab Least Angle Regression \cr
  lasso \tab Lasso Regression \cr
  lightgbm \tab Light Gradient Boosting Machine \cr
  llar \tab Lasso Least Angle Regression \cr
  lr \tab Linear Regression \cr
  omp \tab Orthogonal Matching Pursuit \cr
  par \tab Passive Aggressive Regressor \cr
  rf \tab Random Forest Regressor\cr
  ridge \tab Ridge Regression
}}

\item{sort_v}{A character vector indicating what to sort the tuned models on.}

\item{n_models}{An integer value defaulted to a large integer value to
return all possible models.}

\item{seed}{An integer value to set the seed of the `python` environment.
Default value is set to `NULL`.}

\item{...}{Additional arguments passed onto \link[stressor]{mlm_init}.}
}
\value{
A list object where the first entry is the models fitted and the
  second is the initial predictive accuracy on the random test data. Returns
  as two classes `"mlm_stressor"` and `"regressor"`.
}
\description{
Through the \href{https://pycaret.gitbook.io/docs/get-started/quickstart#regression}{PyCaret}
  module from `python`, this function fits many machine
  learning models simultaneously with without requiring any `python`
  programming on the part of the user. This function is
  specifically designed for the regression models.
}
\details{
`PyCaret` is a `python` module where machine learning models can be fitted with
  little coding by the user. The pipeline that `PyCaret` uses is a
  setup function to parameterize the data that is easy for all the models to
  fit on. Then the compare models function is executed, which fits all the models
  that are currently available. This process takes less than five minutes for
  data.frame objects that are less than 10,000 rows.
}
\examples{
\dontshow{if (python_avail()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 lm_test <- data_gen_lm(20)
 create_virtualenv()
 mlm_lm <- mlm_regressor(Y ~ ., lm_test)
\dontshow{\}) # examplesIf}
}
