% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-after.R
\name{str_nth_number_after_mth}
\alias{str_nth_number_after_mth}
\alias{str_nth_number_after_first}
\alias{str_nth_number_after_last}
\alias{str_first_number_after_mth}
\alias{str_last_number_after_mth}
\alias{str_first_number_after_first}
\alias{str_first_number_after_last}
\alias{str_last_number_after_first}
\alias{str_last_number_after_last}
\title{Find the \code{n}th number after the \code{m}th occurrence of a pattern.}
\usage{
str_nth_number_after_mth(
  string,
  pattern,
  n,
  m,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)

str_nth_number_after_first(
  string,
  pattern,
  n,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)

str_nth_number_after_last(
  string,
  pattern,
  n,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)

str_first_number_after_mth(
  string,
  pattern,
  m,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)

str_last_number_after_mth(
  string,
  pattern,
  m,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)

str_first_number_after_first(
  string,
  pattern,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)

str_first_number_after_last(
  string,
  pattern,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)

str_last_number_after_first(
  string,
  pattern,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)

str_last_number_after_last(
  string,
  pattern,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{The pattern to look for.

The default interpretation is a regular expression, as described in
\link[stringi:about_search_regex]{stringi::about_search_regex}.

To match a without regular expression (i.e. as a human would), use
\link[stringr:modifiers]{coll()}. For details see \code{\link[stringr:modifiers]{stringr::regex()}}.}

\item{n, m}{Vectors of integerish values. Must be either length 1 or have
length equal to the length of \code{string}. Negative indices count from the
back: while \code{1} and \code{2} correspond to first and second, \code{-1} and \code{-2}
correspond to last and second-last. \code{0} will return \code{NA}.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{sci}{Make the search aware of scientific notation e.g. 2e3 is the same
as 2000.}

\item{big_mark}{A character. Allow this character to be used as a thousands
separator. This character will be removed from between digits before they
are converted to numeric. You may specify many at once by pasting them
together e.g. \code{big_mark = ",_"} will allow both commas and underscores.
Internally, this will be used inside a \verb{[]} regex block so e.g. \code{"a-z"}
will behave differently to \code{"az-"}. Most common separators (commas, spaces,
underscores) should work fine.}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}

\item{commas}{Deprecated. Use \code{big_mark} instead.}
}
\value{
A numeric or character vector.
}
\description{
Given a string, a pattern and natural numbers \code{n} and \code{m}, find the \code{n}th
number after the \code{m}th occurrence of the pattern.
}
\examples{
string <- c(
  "abc1abc2abc3abc4abc5abc6abc7abc8abc9",
  "abc1def2ghi3abc4def5ghi6abc7def8ghi9"
)
str_nth_number_after_mth(string, "abc", 1, 3)
str_nth_number_after_mth(string, "abc", 2, 3)
str_nth_number_after_first(string, "abc", 2)
str_nth_number_after_last(string, "abc", -1)
str_first_number_after_mth(string, "abc", 2)
str_last_number_after_mth(string, "abc", 1)
str_first_number_after_first(string, "abc")
str_first_number_after_last(string, "abc")
str_last_number_after_first(string, "abc")
str_last_number_after_last(string, "abc")
}
\seealso{
Other numeric extractors: 
\code{\link{str_extract_numbers}()},
\code{\link{str_nth_number}()},
\code{\link{str_nth_number_before_mth}()}
}
\concept{numeric extractors}
