# kate: default-dictionary en_AU

## stringx package for R
## Copyleft (C) 2021-2025, Marek Gagolewski <https://www.gagolewski.com/>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
## GNU General Public License for more details. You have received
## a copy of the GNU General Public License along with this program.


#' @title Drop-in Replacements for Base String Functions Powered by Stringi
#'
#' @description
#' \pkg{stringx} reimplements the built-in R string processing functions
#' based on \pkg{stringi} -- a mature R package for fast, correct, consistent,
#' and convenient text manipulation. Thanks to the \pkg{ICU} library, we obtain
#' predictable results on every platform, in each locale, and under any
#' native character encoding.
#'
#' \bold{Keywords}: R, text processing, character strings,
#' internationalisation, localisation, ICU, ICU4C, i18n, l10n, Unicode
#'
#' \bold{License}: GNU General Public License version 2 or later
#'
#' @references
#' \emph{\pkg{stringi} Package homepage},
#' \url{https://stringi.gagolewski.com/}
#'
#' \emph{ICU -- International Components for Unicode},
#' \url{https://icu.unicode.org/}
#'
#' \emph{The Unicode Consortium},
#' \url{https://home.unicode.org/}
#'
#'
#' @name about_stringx
#' @rdname about_stringx
#' @aliases about_stringx stringx
#' @docType package
invisible(NULL)
