
# structenforcement

<!-- badges: start -->
[![pipeline status](https://gitlab.com/S_S_/structenforcement/badges/master/pipeline.svg)](https://gitlab.com/S_S_/structenforcement/-/commits/master)
[![coverage report](https://gitlab.com/S_S_/structenforcement/badges/master/coverage.svg)](https://gitlab.com/S_S_/structenforcement/-/commits/master)
[![Latest Release](https://gitlab.com/S_S_/structenforcement/-/badges/release.svg)](https://gitlab.com/S_S_/structenforcement/-/releases)
<!-- badges: end -->

Tools for ensuring that data is correctly typed.  

Without moving over to a strict type system such at that offered by the [`typed`](https://cran.r-project.org/package=typed)
package or enforcing classes everywhere, this offers a straightforward approach
to getting lists (and especially dataframes) into the correct types, where R's
extreme dynamism might infer something incorrectly when it comes to input data.

It is naturally best used in conjunction with other means of ensuring that
structures keep the correct types once they've been cast.
As of the initial implementation, this mostly cares about primitive types. The
only class that is handled neatly is POSIXct.

## Installation

You can install the development version of structenforcement like so:

``` r
remotes::install_gitlab("S_S_/structenforcement")
```

## Example

``` r
library(structenforcement)

template_struct <- data.frame(
    "Sepal.Length"  = integer(0),
    "Sepal.Width"   = numeric(0),
    "Petal.Length"  = numeric(0),
    "Petal.Width"   = numeric(0)
)
type_checked_iris <- type_check(
    template_struct,
    iris,
    TRUE,
    c("casts", "missing", "excess")
)
```

