% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findClusters.R
\name{findClusters}
\alias{findClusters}
\title{Suprathreshold Clusters for Brain Imaging}
\usage{
findClusters(copes, mask = NULL, thr = 3.2, alternative = "two.sided", silent = FALSE)
}
\arguments{
\item{copes}{list of 3D numeric arrays (contrasts maps for each subject).}

\item{mask}{3D logical array, where \code{TRUE} values correspond to voxels inside the brain, or character for a Nifti file name.}

\item{thr}{threshold.}

\item{alternative}{direction of the alternative hypothesis (\code{greater}, \code{lower}, \code{two.sided}).}

\item{silent}{logical, \code{FALSE} to print the number of clusters.}
}
\value{
\code{findClusters} returns a 3D numeric array, with integer values corresponding to clusters,
and 0 to other voxels.
}
\description{
This function determines spatially connected clusters, where t-scores are more extreme than a given threshold.
}
\examples{
# simulate 20 copes with dimensions 10x10x10
set.seed(42)
copes <- list()
for(i in seq(20)){copes[[i]] <- array(rnorm(10^3, mean = -10, sd = 30), dim=c(10,10,10))}

# cluster map where t scores are grater than 2.8, in absolute value
thr <- 2.8
cl <- findClusters(copes = copes, thr = thr)

# create object of class sumBrain
res <- brainScores(copes = copes, alpha = 0.2, seed = 42, truncFrom = thr)
res
summary(res)

# confidence bound for the number of true discoveries and the TDP within clusters
out <- clusterAnalysis(res, clusters = cl$clusters)
}
\seealso{
Permutation statistics for brain imaging: \code{\link{brainScores}}, \code{\link{brainPvals}}

True discovery guarantee for cluster analysis: \code{\link{clusterAnalysis}}
}
\author{
Anna Vesely.
}
