% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hellinger.diag.R
\name{hellinger.diag}
\alias{hellinger.diag}
\alias{hellinger.diag.list}
\alias{hellinger.diag.mcmc.list}
\alias{hellinger.diag.matrix}
\alias{hellinger.diag.mcmc}
\title{Hellinger Distance Diagnostics for MCMC}
\usage{
hellinger.diag(x)

\method{hellinger.diag}{list}(x)

\method{hellinger.diag}{mcmc.list}(x)

\method{hellinger.diag}{matrix}(x, bins, binwidth)

\method{hellinger.diag}{mcmc}(x, bins, binwidth)
}
\value{
A matrix of the estimates.
}
\description{
This computes the Hellinger distance for \code{mcmc} or \code{mcmc.list} objects.
}
\details{
@param x A \code{mcmc} or \code{mcmc.list} object. For mcmc object contains
   one single MCMC chain, the within-chain distance is computed. For \code{mcmc.list}
   object containing multiple MCMC chains, the between distribution distance(s)
   is computed.
 @param bins Number of bins for testing within-chain distance. Defaults to 10.
 @param binwidth Alternative specification for \code{bins}. The size of bin for each batch
  of the chain(s) for computing the distance between batches.
}
\examples{
\dontrun{

data(tobit.list)
summary(tobit.list[1])

# FOR mcmc.list OBJECT
hellinger.diag.mcmc.list(tobit.list)

# FOR mcmc OBJECT
hellinger.diag.mcmc(tobit.list[[1]])

}

}
\references{
Boone, Edward L., Jason RW Merrick, and Matthew J. Krachey (2014). "A
  Hellinger distance approach to MCMC diagnostics." \emph{Journal of Statistical Computation
  and Simulation}, 84 (4), 833-849, \code{doi:10.1080/00949655.2012.729588}.
}
\keyword{internal}
