pairwiseHR <- function(treat, studlab, event, n, data=NULL){

  data <- data.frame(data)
  event <- data[, deparse(substitute(event))]
  n <- data[, deparse(substitute(n))]
  studlab <- data[, deparse(substitute(studlab))]
  treat <- data[, deparse(substitute(treat))]

  id <- as.numeric(studlab)
  uid <- unique(id)
  N <- length(uid)
  
  R1 <- R2 <- NULL
  
  for(i in 1:N){
  
	k <- uid[i]
	wk <- which(id==k)

	if(length(wk)==2){
	
		trtk <- c(treat[wk][1],treat[wk][2])
		Rk <- calcHR(event[wk][1],n[wk][1],event[wk][2],n[wk][2])
		
		R1 <- rbind(R1,c(studlab[wk][1],Rk[[1]],Rk[[2]],n[wk][1],n[wk][2]))
		R2 <- rbind(R2,trtk)
	
	}

	if(length(wk)>=3){
	
		L <- length(wk)
		
		for(j in L:2){
			for(h in 1:(j-1)){
	
				trtk <- c(treat[wk][h],treat[wk][j])
				Rk <- calcHR(event[wk][h],n[wk][h],event[wk][j],n[wk][j])
		
				R1 <- rbind(R1,c(studlab[wk][1],Rk[[1]],Rk[[2]],n[wk][h],n[wk][j]))
				R2 <- rbind(R2,trtk)

			}
		}
		
	}
  
  }
  
  studlab <- R1[,1]
  TE <- R1[,2]
  seTE <- R1[,3]
  treat1 <- R2[,1]
  treat2 <- R2[,2]
  n1 <- R1[,4]
  n2 <- R1[,5]
  
  R <- data.frame(studlab,treat1,treat2,TE,seTE,n1,n2)
  
  return(R)

}
