% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV2_02.r
\name{NR.beta}
\alias{NR.beta}
\title{Inner Newton-Raphson algorithm for regression parameters estimation}
\usage{
NR.beta(build, beta.ini, detail.beta, max.it.beta = 200, tol.beta = 1e-04)
}
\arguments{
\item{build}{list of objects returned by \code{\link{model.cons}}}

\item{beta.ini}{vector of initial regression parameters; default is NULL, in which case the first beta will be \code{log(sum(event)/sum(t1))} and the others will be zero (except if there are "by" variables or if there is a piecewise constant hazard specification in which cases all betas are set to zero)}

\item{detail.beta}{if TRUE, details concerning the optimization process in the regression parameters are displayed; default is FALSE}

\item{max.it.beta}{maximum number of iterations to reach convergence in the regression parameters; default is 200}

\item{tol.beta}{convergence tolerance for regression parameters; default is \code{1e-04}}
}
\value{
List of objects:
\item{beta}{estimated regression parameters}
\item{ll.unpen}{log-likelihood at convergence}
\item{ll.pen}{penalized log-likelihood at convergence}
\item{iter.beta}{number of iterations needed to converge}
}
\description{
Applies Newton-Raphson algorithm for beta estimation. Two specific modifications aims at guaranteeing
convergence : first the hessian is perturbed whenever it is not positive definite and second, at each step, if the penalized
log-likelihood is not maximized, the step is halved until it is.
}
\details{
If we note \code{ll.pen} and \code{beta} respectively the current penalized log-likelihood and estimated parameters and
\code{ll.pen.old} and \code{betaold} the previous ones, the algorithm goes on while
(abs(ll.pen-ll.pen.old)>tol.beta) or any(abs((beta-betaold)/betaold)>tol.beta)
}
\examples{

library(survPen)

# standard spline of time with 4 knots

data <- data.frame(time=seq(0,5,length=100),event=1,t0=0)

form <- ~ smf(time,knots=c(0,1,3,5))

t1 <- eval(substitute(time), data)
t0 <- eval(substitute(t0), data)
event <- eval(substitute(event), data)
	
# Setting up the model before fitting
model.c <- model.cons(form,lambda=0,data.spec=data,t1=t1,t1.name="time",
t0=rep(0,100),t0.name="t0",event=event,event.name="event",
expected=rep(0,100),expected.name=NULL,type="overall",n.legendre=20,
cl="survPen(form,data,t1=time,event=event)",beta.ini=NULL)
 
# Estimating the regression parameters at given smoothing parameter (here lambda=0)
Newton1 <- NR.beta(model.c,beta.ini=rep(0,4),detail.beta=TRUE)

}
