% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds.r
\name{estimate.degree.distns}
\alias{estimate.degree.distns}
\title{Estimate degree distributions by trait}
\usage{
estimate.degree.distns(survey.data, d.hat.vals, traits, keep.vars = NULL)
}
\arguments{
\item{survey.data}{The respondent info}

\item{d.hat.vals}{The variable that contains
the degrees for each respondent}

\item{traits}{A vector of the names of the columns
of \code{survey.data} which refer to the traits}

\item{keep.vars}{Additional vars to return along with degrees}
}
\value{
An object with
\itemize{
\item \code{distns} a list with one entry per trait value; each
\item \code{draw.degrees.fn} a function which gets called with one
\item \code{keep.vars} the name of the other vars that are kept (if any)
}
}
\description{
Break down RDS degree distributions by trait,
and return an object which has the degrees
for each trait as well as functions to draw
degrees from each trait.
}
\details{
One of the items returned as a result is a function,
\code{draw.degrees.fn}, which takes one argument,
\code{traits}. This is a vector of traits and,
for each entry in this vector, \code{draw.degress.fn}
returns a draw from the empirical distribution of
degrees among respondents with that trait. So,
\verb{draw.degrees.fn(c("0.0", "0.1", "0.1")} would
return a degree drawn uniformly at random from among
the observed degrees of respondents with trait "0.0"
and then two degrees from respondents with trait "0.1"
}
