% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suso_gql_deleteuserfrommap.R
\name{suso_gql_deleteuserfrommap}
\alias{suso_gql_deleteuserfrommap}
\title{Delete user from map}
\usage{
suso_gql_deleteuserfrommap(
  endpoint = NULL,
  workspace = NULL,
  user = NULL,
  token = NULL,
  password = NULL,
  fileName = NULL,
  userName = NULL
)
}
\arguments{
\item{endpoint}{GraphQL endpoint of your server}

\item{workspace}{Server Workspace, if NULL uses default}

\item{user}{your API username}

\item{token}{If Survey Solutions server token is provided \emph{apiUser} and \emph{apiPass} will be ignored}

\item{password}{your API user password}

\item{fileName}{the name of the map file on the server}

\item{userName}{the name of the interviewer to whom the map will be assigned to}
}
\value{
if successfull, returns a list with the executed mutation
}
\description{
Allows the user to delete an interviewer from a map to be used in CAPI data collection.
}
\examples{
\dontshow{if (suso_gql_pwcheck()==200) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Requires Survey Solutions Server and API credentials

# Delete map seg_168_ALL.tif from user int0073

suso_gql_deleteuserfrommap(endpoint = ep, user = usr,
password = pass, workspace = ws,
fileName = "seg_168_ALL.tif", userName = "int0073")

\dontshow{\}) # examplesIf}
}
