% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wlasso.R
\name{wlasso}
\alias{wlasso}
\title{Weighted LASSO prediction models for complex survey data}
\usage{
wlasso(
  data = NULL,
  col.y = NULL,
  col.x = NULL,
  cluster = NULL,
  strata = NULL,
  weights = NULL,
  design = NULL,
  family = c("gaussian", "binomial"),
  lambda.grid = NULL,
  method = c("dCV", "JKn", "bootstrap", "subbootstrap", "BRR", "split", "extrapolation"),
  k = 10,
  R = 1,
  B = 200,
  dCV.sw.test = FALSE,
  train.prob = 0.7,
  method.split = c("dCV", "bootstrap", "subbootstrap"),
  print.rw = FALSE
)
}
\arguments{
\item{data}{A data frame with information about the response variable and covariates, as well as sampling weights and strata and cluster indicators. It could be \code{NULL} if the sampling design is indicated in the \code{design} argument.}

\item{col.y}{A numeric value indicating the number of the column in which information on the response variable can be found or a character string indicating the name of that column.}

\item{col.x}{A numeric vector indicating the numbers of the columns in which information on the covariates can be found or a vector of character strings indicating the names of these columns.}

\item{cluster}{A character string indicating the name of the column with cluster identifiers. It could be \code{NULL} if the sampling design is indicated in the \code{design} argument.}

\item{strata}{A character string indicating the name of the column with strata identifiers. It could be \code{NULL} if the sampling design is indicated in the \code{design} argument.}

\item{weights}{A character string indicating the name of the column with sampling weights. It could be \code{NULL} if the sampling design is indicated in the \code{design} argument.}

\item{design}{An object of class \code{survey.design} generated by \code{survey::svydesign()}. It could be \code{NULL} if information about \code{cluster}, \code{strata}, \code{weights} and \code{data} are given.}

\item{family}{A character string indicating the family to fit LASSO models. Choose between \code{gaussian} (to fit linear models) or \code{binomial} (for logistic models).}

\item{lambda.grid}{A numeric vector indicating a grid for penalization parameters. The default option is \code{lambda.grid = NULL}, which considers the default grid selected by the function \code{glmnet::glmnet()}.}

\item{method}{A character string indicating the method to be applied to define replicate weights. Choose between one of these: \code{JKn}, \code{dCV}, \code{bootstrap}, \code{subbootstrap}, \code{BRR}, \code{split}, \code{extrapolation}.}

\item{k}{A numeric value indicating the number of folds to be defined. Default is \code{k=10}. Only applies for the \code{dCV} method.}

\item{R}{A numeric value indicating the number of times the sample is partitioned. Default is \code{R=1}. Only applies for \code{dCV}, \code{split} or \code{extrapolation} methods.}

\item{B}{A numeric value indicating the number of bootstrap resamples. Default is \code{B=200}. Only applies for \code{bootstrap} and  \code{subbootstrap} methods.}

\item{dCV.sw.test}{A logical value indicating the method for estimating the error for \code{dCV} method. \code{FALSE}, (the default option) estimates the error for each test set and defines the cross-validated error based on the average strategy. Option \code{TRUE} estimates the cross-validated error based on the pooling strategy}

\item{train.prob}{A numeric value between 0 and 1, indicating the proportion of clusters (for the method \code{split}) or strata (for the method \code{extrapolation}) to be set in the training sets. Default is \code{train.prob = 0.7}. Only applies for \code{split} and \code{extrapolation} methods.}

\item{method.split}{A character string indicating the way in which replicate weights should be defined in the \code{split} method. Choose one of the following: \code{dCV}, \code{bootstrap} or \code{subbootstrap}. Only applies for \code{split} method.}

\item{print.rw}{A logical value. If \code{TRUE}, the data set with the replicate weights is saved in the output object. Default \code{print.rw=FALSE}.}
}
\value{
The output object of the function \code{wlasso()} is an object of class \code{wlasso}. This object is a list containing 4 or 5 elements, depending on the value set to the argument \code{print.rw}. Below we describe the contents of these elements:
\itemize{
\item \code{lambda}: A list containing information of two elements:
\itemize{
\item \code{grid}: A numeric vector indicating all the values considered for the tuning parameter.
\item \code{min}: A numeric value indicating the value of the tuning parameter that minimizes the average error (i.e., selected optimal tuning parameter).
}
\item \code{error}: A list containing information of two elements:
\itemize{
\item \code{average}: A numeric vector indicating the average error corresponding to each tuning parameter.
\item \code{all}: A numeric matrix indicating the error of each test set for each tuning parameter.
}
\item \code{model}: A list containing information of two elements in relation to the fitted models. Note that all these models are fitted considering the whole data set (and not uniquely the training sets).
\itemize{
\item \code{grid}: A list with the information about the models fitted for each of the tuning parameters considered (i.e., all the values in the \code{lambda$grid} object):
\itemize{
\item \code{a0}: a numeric vector of model intercepts across the whole grid of tuning parameters (hence, of the same length as \code{lambda$grid}).
\item \code{beta}: a matrix of regression coefficients corresponding to all the considered covariates across the whole grid of tuning parameters (the number of rows is equal to the number of covariates considered and the number of columns to the length of \code{lambda$grid}).
\item \code{df}: a numeric vector of the degrees of freedom (i.e., the number of coefficients different from zero) across the whole grid of tuning parameters  (hence, of the same length as \code{lambda$grid}).
}
\item \code{min}: A list with the information about the model fitted considering uniquely the tuning parameter that minimizes the error in the training models (i.e., the optimal tuning parameter selected between the elements in \code{lambda$grid}):
\itemize{
\item \code{a0}: a numeric value indicating the intercept value of the selected model.
\item \code{beta}: a matrix of regression coefficients corresponding to all the considered covariates for the selected tuning parameters (the number of rows is equal to the number of covariates considered and the number of columns is one).
\item \code{df}: a numeric value indicating the degrees of freedom (i.e., the number of coefficients different from zero) of the selected model.
}
}
\item \code{data.rw}: A data frame containing the original data set and the replicate weights added to define training and test sets. Only included in the output object if \code{print.rw=TRUE}.
\item \code{call}: an object containing the information about the way in which the function has been run.
}
}
\description{
This function allows as to fit LASSO prediction (linear or logistic) models to complex survey data, considering sampling weights in the estimation process and selects the lambda that minimizes the error based on different replicating weights methods.
}
\examples{
data(simdata_lasso_binomial)
mcv <- wlasso(data = simdata_lasso_binomial,
              col.y = "y", col.x = 1:50,
              family = "binomial",
              cluster = "cluster", strata = "strata", weights = "weights",
              method = "dCV", k=10, R=1)

# Or equivalently:
\donttest{
mydesign <- survey::svydesign(ids=~cluster, strata = ~strata, weights = ~weights,
                              nest = TRUE, data = simdata_lasso_binomial)
mcv <- wlasso(col.y = "y", col.x = 1:50, design = mydesign,
              family = "binomial",
              method = "dCV", k=10, R=1)
}
}
