% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{svycdiff}
\alias{svycdiff}
\title{Controlled Difference Estimation for Complex Surveys}
\usage{
svycdiff(
  df,
  id_form,
  a_form,
  s_form,
  y_form,
  y_fam = NULL,
  strata = NULL,
  cluster = NULL
)
}
\arguments{
\item{df}{a `data.frame` or `tibble` containing the variables in the models.}

\item{id_form}{a `string` indicating which identification formula to be used.
Options include \code{"OM"}, \code{"IPW1"}, \code{"IPW2"}, or \code{"DR"}.
See 'Details' for information.}

\item{a_form}{an object of class `formula` which describes the propensity
score model to be fit.}

\item{s_form}{an object of class `formula` which describes the selection
model to be fit.}

\item{y_form}{an object of class `formula` which describes the outcome model
to be fit. Only used if \code{id_form = "OM"} or \code{id_form = "DR"},
else \code{y_form = y ~ 1}.}

\item{y_fam}{a `family` function. Only used if \code{id_form = "OM"} or
\code{id_form = "DR"}, else \code{y_fam = NULL}. Current options include
\code{gaussian}, \code{binomial}, or \code{poisson}.}

\item{strata}{a `string` indicating strata, else \code{strata = NULL}
for no strata.}

\item{cluster}{a `string` indicating cluster IDs, else \code{cluster = NULL}
for no clusters.}
}
\value{
`svycdiff` returns an object of class "svycdiff" which contains:

\describe{
   \item{id_form}{A string denoting Which method was selected for estimation}
   \item{cdiff}{A named vector containing the point estimate (est),
                standard error (err), lower confidence limit (lcl),
                upper confidence limit (ucl), and p-value (pval) for
                the estimated controlled difference}
   \item{fit_y}{An object of class inheriting from "glm" corresponding to
                the outcome model fit, or NULL for IPW1 and IPW2}
   \item{fit_a}{An object of class inheriting from "glm" corresponding to
                the propensity model fit}
   \item{wtd_fit_a}{An object of class inheriting from "glm" corresponding
                    to the weighted propensity model fit}
   \item{fit_s}{An object of class "betareg" corresponding to the selection
                model fit, or NULL if the selection mechanism is known}
}
}
\description{
This is the main function to estimate population average controlled
difference (ACD), or under stronger assumptions, the population average
treatment effect (PATE), for a given outcome between levels of a binary
treatment, exposure, or other group membership variable of interest for
clustered, stratified survey samples where sample selection depends on
the comparison group.
}
\details{
The argument \code{id_form} takes possible values \code{"OM"},
\code{"IPW1"}, \code{"IPW2"}, or \code{"DR"}, corresponding to the four
formulas presented in Salerno et al. \code{"OM"} refers to the method that
uses outcome modeling and direct standardization to estimate the controlled
difference, while \code{"IPW1"} and \code{"IPW2"} are inverse probability
weighted methods. \code{"IPW1"} and \code{"IPW2"} differ with respect to how
the joint propensity and selection mechanisms are factored (see Salerno et
al. for additional details). \code{"DR"} refers to the doubly robust form of
estimator, which essentially combines \code{"OM"} and \code{"IPW2"}.

For \code{id_form = "IPW1"} or \code{id_form = "IPW2"}, \code{y_form} should
be of the form \code{Y ~ 1}.

For known selection mechanisms, \code{s_form} should be of the form
\code{pS ~ 1}, where \code{pS} is the variable corresponding to the
probability of selection (e.g., inverse of the selection weight), and there
should be two additional variables in the dataset: \code{P_S_cond_A1X} and
\code{P_S_cond_A0X}, corresponding to the known probability of selection
conditional on \eqn{A = 1} or \eqn{0} and \eqn{X = x}, respectively. If
these quantities are not known, \code{s_form} should contain the variables
which affect sample selection on the right hand side of the equation,
including the comparison group variable of interest.
}
\examples{

N <- 1000

dat <- simdat(N)

S <- rbinom(N, 1, dat$pS)

samp <- dat[S == 1,]

y_mod <- Y ~ A * X1

a_mod <- A ~ X1

s_mod <- pS ~ A + X1

fit <- svycdiff(samp, "DR", a_mod, s_mod, y_mod, "gaussian")

fit

summary(fit)

}
