% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compswap.R
\name{compswap}
\alias{compswap}
\title{Compare swaprinc Models}
\usage{
compswap(
  data,
  formula,
  engine = "stats",
  .prc_eng_list = list("stats"),
  .pca_varlist = list(c(NULL)),
  .n_pca_list = list(NULL),
  .lpca_center_list = list("none"),
  .lpca_scale_list = list("none"),
  .lpca_undo_list = list(FALSE),
  .gifi_transform_list = list("none"),
  .gifi_trans_vars_list = list(c(NULL)),
  .gifi_trans_dims_list = list(NULL),
  .no_tresp_list = list(FALSE),
  .miss_handler_list = list("none"),
  .model_options_list = list("noaddpars"),
  .prcomp_options_list = list("noaddpars"),
  .gifi_princals_options_list = list("noaddpars"),
  .gifi_trans_options_list = list("noaddpars")
)
}
\arguments{
\item{data}{A dataframe}

\item{formula}{A quoted model formula}

\item{engine}{The engine for fitting the model.  Options are "stats" or"lme4".}

\item{.prc_eng_list}{A list of prc_eng values (see swaprinc documentation)}

\item{.pca_varlist}{A list of pca_vars (see swaprinc documentation)}

\item{.n_pca_list}{A list of n_pca_components (see swaprinc documentation)}

\item{.lpca_center_list}{A list of lpca_center values (see swaprinc documentation)}

\item{.lpca_scale_list}{A list of lpca_scale values (see swaprinc documentation)}

\item{.lpca_undo_list}{A list of lpca_undo values (see swaprinc documentation)}

\item{.gifi_transform_list}{A list of gifi_transform values (see swaprinc documentation)}

\item{.gifi_trans_vars_list}{A list of gifi_trans_vars values (see swaprinc documentation)}

\item{.gifi_trans_dims_list}{A list of gifi_trans_dims values (see swaprinc documentation)}

\item{.no_tresp_list}{A list of no_tresp values (see swaprinc documentation)}

\item{.miss_handler_list}{A list of miss_handler values (see swaprinc documentation)}

\item{.model_options_list}{A list of model_options (see swaprinc documentation)}

\item{.prcomp_options_list}{A list of prcomp_options (see swaprinc documentation)}

\item{.gifi_princals_options_list}{A list of gifi_princals_options (see swaprinc documentation)}

\item{.gifi_trans_options_list}{A list of gifi_trans_options (see swaprinc documentation)}
}
\value{
A list containing a list of fitted models and a comparison metrics
data frame.
}
\description{
The \code{swaprinc} function compares a regression model using raw variables to a
model with principal components swapped in. The \code{compswap} function compares
a regression model with raw variables to multiple models with principal
components swapped in. Parameter lists are recycled to ensure they are the
same length as the longest parameter list.
}
\examples{
# Load the iris dataset
data(iris)

# Define the formula
formula <- "Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width"

# Define the pca_varlist
pca_varlist <- list(c("Sepal.Width", "Petal.Length"),
                   c("Sepal.Width", "Petal.Width"))

# Define the n_pca_list
n_pca_list <- list(2, 2)

# Set scaling values
lpca_center_list <- list("none", "none")
lpca_scale_list <- list("none", "none")
lpca_undo_list <- list(FALSE, FALSE)

# Run compswap
compswap_results <- compswap(data = iris,
                            formula = formula,
                            engine = "stats",
                            .pca_varlist = pca_varlist,
                            .n_pca_list = n_pca_list,
                            .lpca_center_list = lpca_center_list,
                            .lpca_scale_list = lpca_scale_list,
                            .lpca_undo_list = lpca_undo_list)
}
