% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demod.R
\name{matching_demod}
\alias{matching_demod}
\title{Matching Demodulation}
\usage{
matching_demod(x, n, thresh = 0.05, max_cycles = 5,
  smooth = "butterworth", order = 5, passfreq = 0.1, debug = FALSE)
}
\arguments{
\item{x}{numeric. Signal to demodulate}

\item{n}{integer. Window size for SWDFT}

\item{thresh}{numeric. Threshold to determine whether to continue demodulating}

\item{max_cycles}{maximum number of demodulation cycles}

\item{smooth}{character. Type of smoothing to use, accepts either 'ma', 'double_ma',
or 'butterworth' (the default)}

\item{order}{moving average parameter if 'smooth' argument equals 'ma' or 'double_ma'. Defaults to 5}

\item{passfreq}{numeric scalar. Pass frequency used in butterworth low-pass filter. defaults to .1}

\item{debug}{Logical. Whether to print out intermediate output.}
}
\value{
An S3 'swdft_matching_demod' object. See ?new_swdft_matching_demod for details.
}
\description{
Matching Demodulation
}
