% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Section6}
\alias{Section6}
\alias{swe_sol_eclipse_when_loc}
\alias{swe_sol_eclipse_when_glob}
\alias{swe_sol_eclipse_how}
\alias{swe_sol_eclipse_where}
\alias{swe_lun_occult_when_loc}
\alias{swe_lun_occult_when_glob}
\alias{swe_lun_occult_where}
\alias{swe_lun_eclipse_when_loc}
\alias{swe_lun_eclipse_how}
\alias{swe_lun_eclipse_when}
\alias{swe_rise_trans_true_hor}
\alias{swe_pheno_ut}
\alias{swe_pheno}
\alias{swe_azalt}
\alias{swe_azalt_rev}
\alias{swe_refrac}
\alias{swe_refrac_extended}
\alias{swe_heliacal_ut}
\alias{swe_vis_limit_mag}
\alias{swe_heliacal_pheno_ut}
\alias{swe_topo_arcus_visionis}
\alias{swe_heliacal_angle}
\title{Section 6: Eclipses, Risings, Settings, Meridian Transits, Planetary Phenomena}
\usage{
swe_sol_eclipse_when_loc(jd_start, ephe_flag, geopos, backward)

swe_sol_eclipse_when_glob(jd_start, ephe_flag, ifltype, backward)

swe_sol_eclipse_how(jd_ut, ephe_flag, geopos)

swe_sol_eclipse_where(jd_ut, ephe_flag)

swe_lun_occult_when_loc(jd_start, ipl, starname, ephe_flag, geopos, backward)

swe_lun_occult_when_glob(jd_start, ipl, starname, ephe_flag, ifltype, backward)

swe_lun_occult_where(jd_ut, ipl, starname, ephe_flag)

swe_lun_eclipse_when_loc(jd_start, ephe_flag, geopos, backward)

swe_lun_eclipse_how(jd_ut, ephe_flag, geopos)

swe_lun_eclipse_when(jd_start, ephe_flag, ifltype, backward)

swe_rise_trans_true_hor(
  jd_ut,
  ipl,
  starname,
  ephe_flag,
  rsmi,
  geopos,
  atpress,
  attemp,
  horhgt
)

swe_pheno_ut(jd_ut, ipl, ephe_flag)

swe_pheno(jd_et, ipl, ephe_flag)

swe_azalt(jd_ut, coord_flag, geopos, atpress, attemp, xin)

swe_azalt_rev(jd_ut, coord_flag, geopos, xin)

swe_refrac(InAlt, atpress, attemp, calc_flag)

swe_refrac_extended(InAlt, height, atpress, attemp, lapse_rate, calc_flag)

swe_heliacal_ut(jd_utstart, dgeo, datm, dobs, objectname, event_type, helflag)

swe_vis_limit_mag(jd_ut, dgeo, datm, dobs, objectname, helflag)

swe_heliacal_pheno_ut(jd_ut, dgeo, datm, dobs, objectname, event_type, helflag)

swe_topo_arcus_visionis(
  jd_ut,
  dgeo,
  datm,
  dobs,
  helflag,
  mag,
  AziO,
  AltO,
  AziS,
  AziM,
  AltM
)

swe_heliacal_angle(
  jd_ut,
  dgeo,
  datm,
  dobs,
  helflag,
  mag,
  AziO,
  AziS,
  AziM,
  AltM
)
}
\arguments{
\item{jd_start}{Julian day number as double (UT)}

\item{ephe_flag}{Ephemeris flag as integer (\code{SE$FLG_JPLEPH=1}, \code{SE$FLG_SWIEPH=2} or \code{SE$FLG_MOSEPH=4})}

\item{geopos}{position as numeric vector (longitude, latitude, height)}

\item{backward}{backwards search as boolean (TRUE)}

\item{ifltype}{eclipse type as integer (\code{SE$ECL_CENTRAL=1}, \code{SE$ECL_NONCENTRAL=2},
\code{SE$ECL_TOTAL=4}, \code{SE$ECL_ANNULAR=8}, \code{SE$ECL_PARTIAL=16}, \code{SE$ECL_ANNULAR_TOTAL=32} or 0 for any)}

\item{jd_ut}{UT Julian day number as double (day)}

\item{ipl}{Body/planet as integer (\code{SE$SUN=0}, \code{SE$MOON=1}, ... \code{SE$PLUTO=9})}

\item{starname}{Star name as string (\code{""} for no star)}

\item{rsmi}{Event flag as integer (e.g.: \code{SE$CALC_RISE=1}, \code{SE$CALC_SET=2}, \code{SE$CALC_MTRANSIT=4}, \code{SE$CALC_ITRANSIT=8})}

\item{atpress}{Atmospheric pressure as double (hPa)}

\item{attemp}{Atmospheric temperature as double (Celsius)}

\item{horhgt}{Horizon apparent altitude as double (deg)}

\item{jd_et}{ET Julian day number as double (day)}

\item{coord_flag}{Coordinate flag as integer (reference system (\code{SE$ECL2HOR=0} or \code{SE$EQU2HOR=1}))}

\item{xin}{Position of body as numeric vector (either ecliptical or equatorial coordinates, depending on coord_flag)}

\item{InAlt}{object's apparent/topocentric altitude as double (depending on calc_flag) (deg)}

\item{calc_flag}{Calculation flag as integer (refraction direction (\code{SE$TRUE_TO_APP=0} or \code{SE$APP_TO_TRUE=1}))}

\item{height}{observer's height as double (m)}

\item{lapse_rate}{lapse rate as double (K/m)}

\item{jd_utstart}{UT Julian day number as double (day)}

\item{dgeo}{Geographic position as numeric vector (longitude, latitude, height)}

\item{datm}{Atmospheric conditions as numeric vector (pressure, temperature, relative humidity, visibility)}

\item{dobs}{Observer description as numeric vector}

\item{objectname}{Name of fixed star or planet as string}

\item{event_type}{Event type as integer}

\item{helflag}{Calculation flag (incl. ephe_flag values) as integer}

\item{mag}{Object's visible magnitude (Vmag) as double (-)}

\item{AziO}{Object's azimuth as double (deg)}

\item{AltO}{Object's altitude as double (deg)}

\item{AziS}{Sun's azimuth as double (deg)}

\item{AziM}{Moon's azimuth as double (deg)}

\item{AltM}{Moon's altitude as double (deg)}
}
\value{
\code{swe_sol_eclipse_when_loc} returns a list with named entries:
     \code{return} status flag as integer, \code{tret} for eclipse timing moments as numeric vector,
     \code{attr} phenomena during eclipse as numeric vector and \code{serr} error message as string

\code{swe_sol_eclipse_when_glob} returns a list with named entries:
     \code{return} status flag as integer, \code{tret} for eclipse timing moments as numeric vector
     and \code{serr} error warning as string

\code{swe_sol_eclipse_how} returns a list with named entries:
     \code{return} status flag as integer,
     \code{attr} phenomena during eclipse as numeric vector and \code{serr} error message as string

\code{swe_sol_eclipse_where} returns a list with named entries:
     \code{return} status flag as integer, \code{pathpos} geographic path positions as numeric vector,
     \code{attr} phenomena during eclipse as numeric vector and \code{serr} error message as string

\code{swe_lun_occult_when_loc} returns a list with named entries:
     \code{return} status flag as integer, \code{tret} for eclipse timing moments as numeric vector,
     \code{attr} phenomena during eclipse as numeric vector and \code{serr} error message as string

\code{swe_lun_occult_when_glob} returns a list with named entries:
     \code{return} status flag as integer, \code{tret} for eclipse timing moments as numeric vector,
     \code{attr} phenomena during eclipse as numeric vector and \code{serr} error message as string

\code{swe_lun_occult_where} returns a list with named entries:
     \code{return} status flag as integer, \code{pathpos} geographic path positions as numeric vector,
     \code{attr} phenomena during eclipse as numeric vector and \code{serr} error message as string

\code{swe_lun_eclipse_when_loc} returns a list with named entries:
     \code{return} status flag as integer, \code{tret} for eclipse timing moments,
     \code{attr} phenomena during eclipse and \code{serr} error warning as string

\code{swe_lun_eclipse_how} returns a list with named entries:
     \code{return} status flag as integer,
     \code{attr} phenomena during eclipse as numeric vector and \code{serr} error message as string

\code{swe_lun_eclipse_when} returns a list with named entries:
     \code{return} status flag as integer, \code{tret} for eclipse timing moments as numeric vector
     and \code{serr} error warning as string

\code{swe_rise_trans_true_hor} returns a list with named entries: \code{return} status flag as integer,
     \code{tret} for azimuth/altitude info as double and \code{serr} error message as string

\code{swe_pheno_ut} returns a list with named entries:
     \code{return} status fag as integer, \code{attr} for phenomenon information as numeric vector
     and \code{serr} error warning as string

\code{swe_pheno} returns a list with named entries:
     \code{return} status fag as integer, \code{attr} for phenomenon information as numeric vector
     and \code{serr} error message as string

\code{swe_azalt} returns a list with named entries:
     \code{xaz} for azi/alt info as numeric vector.

\code{swe_azalt_rev} returns a list with named entries:
     \code{xaz} for celestial info as numeric vector.

\code{swe_refrac} returns the (apparent/topocentric) altitude as double (deg)

\code{swe_refrac_extended} returns a list with named entries: \code{return} status flag as integer,
     \code{dret} refraction results as numeric vector (TopoAlt, AppAlt, refraction)

\code{swe_heliacal_ut} returns a list with named entries \code{return} status flag as integer,
        \code{dret} heliacal results as numeric vector, and \code{serr} error message as string.

\code{swe_vis_limit_mag} returns a list with named entries: \code{return} status flag as integer,
     \code{dret} limiting magnitude as double and \code{serr} error message as string

\code{swe_heliacal_pheno_ut} returns a list with named entries: \code{return} status flag as integer
     \code{darr} for heliacal details as numeric vector and \code{serr} error message as string

\code{swe_topo_arcus_visionis} returns a list with named entries: \code{return} status flag as integer,
     \code{darr} heliacal details as numeric vector and \code{serr} error message as string

\code{swe_heliacal_angle} returns a list with named entries: \code{return} status flag as integer,
     \code{dret} heliacal angle as numeric vector and \code{serr} error message as string
}
\description{
Functions for: determining eclipse and occultation calculations, computing the times of rising, setting and
meridian transits for all planets, asteroids, the moon and the fixed stars; computing phase, phase angle, elongation,
apparent diameter, apparent magnitude for the Sun, the Moon, all planets and asteroids; and determining
heliacal phenomenon after a given start date
}
\details{
\describe{
  \item{swe_sol_eclipse_when_loc()}{Find the next solar eclipse for a given geographic position.}
  }

\describe{
\item{swe_sol_eclipse_when_glob()}{Find the next solar eclipse on earth.}
}

\describe{
\item{swe_sol_eclipse_how()}{Compute the attributes of a solar eclipse for a given time.}
}

\describe{
\item{swe_sol_eclipse_where()}{Compute the geographic position of a solar eclipse path.}
}

\describe{
\item{swe_lun_occult_when_loc()}{Find the next lunar occultation with planet or star at a certain position.}
}

\describe{
\item{swe_lun_occult_when_glob()}{Find the next lunar occultation with planet or star somewhere on the earth.}
}

\describe{
\item{swe_lun_occult_where()}{Compute the geographic position of an occultation path.}
}

\describe{
\item{swe_lun_eclipse_when_loc()}{Find the next lunar eclipse for a given geographic position.}
}

\describe{
\item{swe_lun_eclipse_how()}{Compute the attributes of a lunar eclipse for a given time.}
}

\describe{
\item{swe_lun_eclipse_when()}{Find the next lunar eclipse on earth.}
}

\describe{
\item{swe_rise_trans_true_hor()}{Compute the times of rising, setting and meridian transits for planets, asteroids, the moon, and the fixed stars for a local horizon that has an altitude. }
}

\describe{
\item{swe_pheno_ut()}{Compute phase, phase angle, elongation, apparent diameter, apparent magnitude for the Sun, the Moon, all planets and asteroids (UT)}
}

\describe{
\item{swe_pheno()}{Compute phase, phase angle, elongation, apparent diameter, apparent magnitude for the Sun, the Moon, all planets and asteroids (ET).}
}

\describe{
\item{swe_azalt()}{Compute the horizontal coordinates (azimuth and altitude) of a planet or a star from either ecliptical or equatorial coordinates.}
}

\describe{
\item{swe_azalt_rev()}{Compute either ecliptical or equatorial coordinates from azimuth and true altitude.
If only an apparent altitude is given, the true altitude has to be computed first with
e.g. the function swe_refrac_extended().}
}

\describe{
\item{swe_refrac()}{Calculate either the topocentric altitude from the apparent altitude
or the apparent altitude from the topocentric altitude.}
}

\describe{
\item{swe_refrac_extended()}{Calculate either the topocentric altitude from the apparent altitude
or the apparent altitude from the topocentric altitude.
It allows correct calculation of refraction for heights above sea > 0,
where the ideal horizon and planets that are visible may have a negative altitude. }
}

\describe{
\item{swe_heliacal_ut()}{Compute the Julian day of the next heliacal phenomenon after a given UT start date.
It works between geographic latitudes 60 South and 60 North.}
}

\describe{
\item{swe_vis_limit_mag()}{Determine the limiting visual magnitude in dark skies. If the visual magnitude mag of an object is known
for a given date (e. g. from a call of function swe_pheno_ut(), and if magnitude is smaller than the value returned
by swe_vis_limit_mag(), then it is visible.}
}

\describe{
\item{swe_heliacal_pheno_ut()}{Provide data that are relevant for the calculation of heliacal risings and settings.
This function does not provide data of heliacal risings and settings itself, just some
additional data mostly used for test purposes. To calculate heliacal risings and settings,
use the function swe_heliacal_ut().}
}

\describe{
\item{swe_topo_arcus_visionis()}{Compute topocentric arcus visionis.}
}

\describe{
\item{swe_heliacal_angle()}{Compute heliacal angle.}
}
}
\examples{
data(SE)
swe_sol_eclipse_when_loc(1234567,SE$FLG_MOSEPH,c(0,50,10),FALSE)
swe_sol_eclipse_when_glob(1234567,SE$FLG_MOSEPH,SE$ECL_TOTAL+SE$ECL_CENTRAL+SE$ECL_NONCENTRAL,FALSE)
swe_sol_eclipse_how(1234580.19960447,SE$FLG_MOSEPH,c(0,50,10))
swe_sol_eclipse_where(1234771.68584597,SE$FLG_MOSEPH)
swe_lun_occult_when_loc(1234567,SE$VENUS,"",SE$FLG_MOSEPH+SE$ECL_ONE_TRY,c(0,50,10),FALSE)
swe_lun_occult_when_glob(1234567,SE$VENUS,"",SE$FLG_MOSEPH+SE$ECL_ONE_TRY,SE$ECL_TOTAL,FALSE)
swe_lun_occult_where(1234590.44756319,SE$VENUS,"",SE$FLG_MOSEPH+SE$ECL_ONE_TRY)
swe_lun_eclipse_when_loc(1234567,SE$FLG_MOSEPH,c(0,50,10),FALSE)
swe_lun_eclipse_when(1234567,SE$FLG_MOSEPH,SE$ECL_CENTRAL,FALSE)
swe_lun_eclipse_how(1234580.19960447,SE$FLG_MOSEPH,c(0,50,10))
swe_rise_trans_true_hor(1234567.5,SE$SUN,"",SE$FLG_MOSEPH,0,c(0,50,10),1013.25,15,0)
swe_pheno_ut(1234567,1,SE$FLG_MOSEPH)
swe_pheno(1234567,1,SE$FLG_MOSEPH)
swe_azalt(1234567,SE$EQU2HOR,c(0,50,10),15,1013.25,c(186,22))
swe_azalt_rev(1234567,SE$ECL2HOR,c(0, 50,10),c(123,2))
swe_refrac_extended(2,0,1013.25,15,-0.065,SE$TRUE_TO_APP)
swe_heliacal_ut(1234567,c(0,50,10),c(1013.25,15,50,0.25),c(25,1,1,1,5,0.8),"sirius",
  SE$HELIACAL_RISING,SE$HELFLAG_HIGH_PRECISION+SE$FLG_MOSEPH)
swe_vis_limit_mag(1234567.5,c(0,50,10),c(1013.25,15,20,0.25),c(25,1,1,1,5,0.8),'sirius',
  SE$HELFLAG_HIGH_PRECISION+SE$FLG_MOSEPH)
swe_heliacal_pheno_ut(1234567.5,c(0,50,10),c(1013.25,15,20,0.25),c(25,1,1,1,5,0.8),'sirius',
  SE$HELIACAL_RISING,SE$HELFLAG_HIGH_PRECISION+SE$FLG_MOSEPH)
swe_topo_arcus_visionis(1234567.5,c(0,50,10),c(1013.25,15,20,0.25),c(25,1,1,1,5,0.8),
  SE$HELFLAG_HIGH_PRECISION+SE$HELFLAG_OPTICAL_PARAMS,-1,124,2,120,0,-45)
swe_heliacal_angle(1234567.5,c(0,50,10),c(1013.25,15,20,0.25),c(25,1,1,1,5,0.8),
  SE$HELFLAG_HIGH_PRECISION+SE$HELFLAG_OPTICAL_PARAMS,-1,124,120,0,-45)
}
\seealso{
Section 6 in \url{https://www.astro.com/swisseph/swephprg.htm}. Remember that array indices start in R at 1, while in C they start at 0!
}
