% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparam.R
\name{etfe}
\alias{etfe}
\title{Estimate empirical transfer function}
\usage{
etfe(data, n = 128)
}
\arguments{
\item{data}{an object of class \code{idframe}}

\item{n}{frequency spacing (Default: \code{128})}
}
\value{
an \code{idfrd} object containing the estimated frequency response
}
\description{
Estimates the emperical transfer function from the data by taking the 
ratio of the fourier transforms of the output and the input variables
}
\examples{
data(arxsim)
frf <- etfe(arxsim)

}
\references{
Arun K. Tangirala (2015), \emph{Principles of System Identification: 
Theory and Practice}, CRC Press, Boca Raton. Sections 5.3 and 20.4.2
}
\seealso{
\code{\link[stats]{fft}}
}

