% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iv.R
\name{iv}
\alias{iv}
\title{ARX model estimation using instrumental variable method}
\usage{
iv(z, order = c(0, 1, 0), x = NULL)
}
\arguments{
\item{z}{an idframe object containing the data}

\item{order}{Specification of the orders: the three integer components 
(na,nb,nk) are the order of polynolnomial A, (order of polynomial B + 1) 
and the input-output delay}

\item{x}{instrument variable matrix. x must be of the same size as the output 
data. (Default: \code{NULL})}
}
\value{
An object of class \code{estpoly} containing the following elements:
 \item{sys}{an \code{idpoly} object containing the 
   fitted ARX coefficients}
 \item{fitted.values}{the predicted response}
 \item{residuals}{the residuals}
 \item{input}{the input data used}
 \item{call}{the matched call}
 \item{stats}{A list containing the following fields: \cr
     \code{vcov} - the covariance matrix of the fitted coefficients \cr
     \code{sigma} - the standard deviation of the innovations\cr
     \code{df} - the residual degrees of freedom}
}
\description{
Estimates an ARX model of the specified order from input-output data using
the instrument variable method. If arbitrary instruments are not supplied 
by the user, the instruments are generated using the arx routine
}
\examples{
data(arxsim)
mod_iv <- iv(arxsim,c(2,1,1))

}
\references{
Arun K. Tangirala (2015), \emph{Principles of System Identification: 
Theory and Practice}, CRC Press, Boca Raton. Sections 21.7.1, 21.7.2

Lennart Ljung (1999), \emph{System Identification: Theory for the User}, 
2nd Edition, Prentice Hall, New York. Section 7.6
}
\seealso{
\code{\link{arx}}, \code{\link{iv4}}
}

