% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcm.R
\name{pcm}
\alias{pcm}
\alias{pcm,data.frame-method}
\title{partial cross mapping}
\usage{
\S4method{pcm}{data.frame}(
  data,
  cause,
  effect,
  conds,
  libsizes = NULL,
  E = 3,
  tau = 1,
  k = E + 1,
  theta = 1,
  algorithm = "simplex",
  lib = NULL,
  pred = NULL,
  dist.metric = "L1",
  dist.average = TRUE,
  threads = length(pred),
  parallel.level = "low",
  bidirectional = TRUE,
  cumulate = FALSE,
  progressbar = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{conds}{name of conditioning variables.}

\item{libsizes}{(optional) number of time points used.}

\item{E}{(optional) embedding dimensions.}

\item{tau}{(optional) step of time lags.}

\item{k}{(optional) number of nearest neighbors.}

\item{theta}{(optional) weighting parameter for distances, useful when \code{algorithm} is \code{smap}.}

\item{algorithm}{(optional) prediction algorithm.}

\item{lib}{(optional) libraries indices.}

\item{pred}{(optional) predictions indices.}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{dist.average}{(optional) whether to average distance.}

\item{threads}{(optional) number of threads to use.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{cumulate}{(optional) serial or cumulative computation of partial cross mapping.}

\item{progressbar}{(optional) whether to show the progress bar.}
}
\value{
A list
\describe{
\item{\code{pxmap}}{partial cross mapping results}
\item{\code{xmap}}{cross mapping results}
\item{\code{varname}}{names of causal, effect and conditioning variables}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
partial cross mapping
}
\examples{
sim = logistic_map(x = 0.4,y = 0.4,z = 0.4,step = 45,
                   beta_xy = 0.5, beta_xz = 0,
                   beta_yx = 0, beta_yz = 0.5,
                   beta_zx = 0, beta_zy = 0)
pcm(sim,"x","z","y",libsizes = seq(5,45,5),E = 10,k = 7,threads = 1)

}
\references{
Leng, S., Ma, H., Kurths, J. et al. Partial cross mapping eliminates indirect causal influences. Nat Commun 11, 2632 (2020).
}
