% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_spec.R
\name{format_small}
\alias{format_small}
\title{Format values right of decimal}
\usage{
format_small(rspec, mark = "", interval = 5L)
}
\arguments{
\item{rspec}{a \code{rounding_specification} object (see \link{round_spec}).}

\item{mark}{a character value used to separate number groups to the
right of the decimal point. See \link{prettyNum} for more details on this.
Set this input to '' to negate it's effect.}

\item{interval}{a numeric value indicating the size of number groups
for numbers left of the decimal.}
}
\value{
an object of class \code{rounding_specification}.
}
\description{
Values to the right of the decimal are generally called 'small' since they
are smaller than values to the left of the decimal. \code{format_small()}
lets you update the settings of a \code{rounding_specification} object
(see \link{round_spec}) so that values right of the decimal will be printed
with a specific format (see examples).
}
\examples{

small_x <- 0.1234567

rspec <- round_spec()
rspec <- round_using_decimal(rspec, digits = 7)
rspec <- format_small(rspec, mark = '*', interval = 1)

table_value(small_x, rspec)

}
\seealso{
Other formatting helpers: 
\code{\link{format_decimal}()}
}
\concept{formatting helpers}
