% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{card}
\alias{card}
\alias{pre_title}
\alias{title}
\alias{page_header}
\alias{value_box}
\alias{icon}
\alias{alert}
\alias{button}
\title{Create a Tabler Card}
\usage{
card(..., title = NULL, footer = NULL, status = NULL, class = NULL)

pre_title(text)

title(text)

page_header(title_text, pretitle_text = NULL, ...)

value_box(value, title, icon = NULL, color = "primary", width = 3)

icon(name, library = "tabler", class = NULL)

alert(..., type = "info", dismissible = FALSE, title = NULL)

button(
  label,
  href = NULL,
  onclick = NULL,
  color = "primary",
  size = "md",
  outline = FALSE,
  icon = NULL,
  icon_right = FALSE,
  disabled = FALSE,
  block = FALSE,
  pill = FALSE,
  square = FALSE,
  loading = FALSE,
  class = NULL,
  type = "button",
  ...
)
}
\arguments{
\item{...}{Additional HTML attributes}

\item{title}{Alert title (optional)}

\item{footer}{Card footer content (optional)}

\item{status}{Card color status: "primary", "secondary", "success", "warning", "danger", etc.}

\item{class}{Additional CSS classes}

\item{text}{The title text to display}

\item{title_text}{The main title text}

\item{pretitle_text}{The pretitle text (optional)}

\item{value}{Main value to display}

\item{icon}{Icon to include}

\item{color}{Button color theme}

\item{width}{Column width (1-12)}

\item{name}{Icon name}

\item{library}{Icon library: "tabler", "bootstrap", "feather"}

\item{type}{HTML button type attribute}

\item{dismissible}{Whether alert can be dismissed}

\item{label}{Button text}

\item{href}{URL to link to (creates an anchor tag instead of button)}

\item{onclick}{JavaScript to execute on click}

\item{size}{Button size: "sm", "md", "lg"}

\item{outline}{Use outline style}

\item{icon_right}{Position icon on the right side}

\item{disabled}{Whether the button is disabled}

\item{block}{Make button full-width (block-level)}

\item{pill}{Use pill-shaped button style}

\item{square}{Use square button style}

\item{loading}{Show loading spinner}
}
\value{
An HTML tag representing the card

An HTML tag representing the value box

An HTML tag representing the icon

An HTML tag representing the alert

An HTML tag representing the button
}
\description{
Build a modern card component with optional header, body, and footer

Small helper to render the page pretitle element used by Tabler examples

Small helper to render the page title element used by Tabler examples

Create the full page header structure with pretitle and title

Display a key metric or value prominently

Display an icon from Tabler Icons or other icon libraries

Display important messages to users

Create interactive buttons with Tabler styling
}
