% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_thumbnails.R
\name{make_thumbnails}
\alias{make_thumbnails}
\title{make_thumbnails}
\usage{
make_thumbnails(
  file,
  outdir = NULL,
  pages = NULL,
  format = c("png", "jpeg", "bmp", "gif"),
  resolution = 72,
  password = NULL,
  copy = FALSE
)
}
\arguments{
\item{file}{A character string specifying the path or URL to a PDF file.}

\item{outdir}{An optional character string specifying a directory into which
to split the resulting files. If \code{NULL}, the \code{outdir} is
\code{tempdir()}. If \code{file} is a URL, both file and thumbnails are
stored in the R session's temporary directory.}

\item{pages}{An optional integer vector specifying pages to extract from.}

\item{format}{A character string specifying an image file format.}

\item{resolution}{A numeric value specifying the image resolution in DPI.}

\item{password}{Optionally, a character string containing a user password
to access a secured PDF.}

\item{copy}{Specifies whether the original local file(s) should be copied to
\code{tempdir()} before processing. \code{FALSE} by default. The argument is
ignored if \code{file} is URL.}
}
\value{
A character vector of file paths.
}
\description{
Convert Pages to Image Thumbnails
}
\details{
This function save each (specified) page of a document as an image
with 720 dpi resolution. Images are saved in the same directory as the
original file, with file names specified by the original file name,
a page number, and the corresponding file format extension.
}
\note{
This may generate Java \dQuote{INFO} messages in the console,
which can be safely ignored.
}
\examples{
# simple demo file
f <- system.file("examples", "mtcars.pdf", package = "tabulapdf")

make_thumbnails(f)
}
\references{
\href{https://tabula.technology/}{Tabula}
}
\seealso{
\code{\link{extract_tables}}, \code{\link{extract_text}},
\code{\link{make_thumbnails}}
}
\author{
Thomas J. Leeper <thosjleeper@gmail.com>
}
