% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diag.panel.splom.density.R
\name{diag.panel.splom.density}
\alias{diag.panel.splom.density}
\title{Diagonal Density Panels}
\usage{
diag.panel.splom.density(
  x,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  weights = NULL,
  n = 512,
  ...
)
}
\arguments{
\item{x}{data vector corresponding to that row / column (which will be the
same for diagonal 'panels').}

\item{bw}{the smoothing bandwidth to be used.  The kernels are scaled
    such that this is the standard deviation of the smoothing kernel.
    (Note this differs from the reference books cited below.)

    \code{bw} can also be a character string giving a rule to choose the
    bandwidth.  See \code{\link[stats]{bw.nrd}}. \cr The default,
    \code{"nrd0"}, has remained the default for historical and
    compatibility reasons, rather than as a general recommendation,
    where e.g., \code{"SJ"} would rather fit, see also
    Venables and Ripley (2002).

    The specified (or computed) value of \code{bw} is multiplied by
    \code{adjust}.
  }

\item{adjust}{the bandwidth used is actually \code{adjust*bw}.
    This makes it easy to specify values like \sQuote{half the default}
    bandwidth.}

\item{kernel}{the smoothing kernel to be used. See \code{\link[stats:density]{stats::density()}} for
options.}

\item{weights}{numeric vector of non-negative observation weights,
    hence of same length as \code{x}. The default \code{NULL} is
    equivalent to \code{weights = rep(1/nx, nx)} where \code{nx} is the
    length of (the finite entries of) \code{x[]}.  If \code{na.rm = TRUE}
    and there are \code{NA}'s in \code{x}, they \emph{and} the
    corresponding weights are removed before computations.  In that case,
    when the original weights have summed to one, they are re-scaled to
    keep doing so.

    Note that weights are \emph{not} taken into account for automatic
    bandwidth rules, i.e., when \code{bw} is a string.  When the weights
    are proportional to true counts \code{cn}, \code{density(x = rep(x, cn))}
    may be used instead of \code{weights}.
  }

\item{n}{the number of equally spaced points at which the density is
    to be estimated.  When \code{n > 512}, it is rounded up to a power
    of 2 during the calculations (as \code{\link[stats]{fft}} is used) and the
    final result is interpolated by \code{\link[stats]{approx}}.  So it almost
    always makes sense to specify \code{n} as a power of two.
  }

\item{...}{Further arguments passed on to \code{\link[lattice:panel.pairs]{lattice::diag.panel.splom()}} and
\code{\link[lattice:llines]{lattice::panel.lines()}}.}
}
\description{
Plots univariate density estimates estimates to be used in a
\code{\link[lattice:splom]{lattice::splom()}} call with the \code{diag.panel} argument.
}
\examples{
splom(~ iris[1:4],
  data = iris,
  diag.panel = diag.panel.splom.density,
  pscales = 0
)
}
\seealso{
\code{\link[lattice:panel.pairs]{lattice::diag.panel.splom()}}, \code{\link[lattice:splom]{lattice::splom()}},
\code{\link[stats:density]{stats::density()}}.
}
