% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{timing_atc_group}
\alias{timing_atc_group}
\title{Timing and ATC pattern interactions}
\usage{
timing_atc_group(
  object,
  only = NULL,
  clusters = NULL,
  atc_groups = default_atc_groups,
  additional_data = NULL,
  ...
)
}
\arguments{
\item{object}{An object for which a summary is desired.}

\item{only}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{object} and/or \code{additional_data}.

The default \code{NULL} selects all clusterings in \code{object}.}

\item{clusters}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An unquoted
expression naming the cluster or clusters in \code{object} one wants to
see summaries of. Names can be used as if they were positions in the data
frame, so expressions like I:IV can be used to select a range of clusters.

The default \code{NULL} selects all clusters in the chosen clusterings of
\code{object}.}

\item{atc_groups}{A data.frame specifying the ATC groups to summaries by or
a funciton that returns such a data.frame. The data.frame must have two
columns:
\itemize{
\item \code{regex} giving regular expressions specifying the wanted ATC groups.
\item \code{atc_groups} the name of this ATC grouping.
}

As a standard the anatomical level (first level) of the ATC codes is used.}

\item{additional_data}{A data frame with additional data that may be
(left-)joined onto the \code{parameters} in \code{object}. This is often
used in conjuction with \code{only} to select specific clusterings based on
\code{additional_data}.}

\item{...}{Additional arguments passed to the specific summary sub-function.}
}
\value{
\code{timing_atc_group()} returns a list of class
\code{timing_atc_group} with two data frames:
\subsection{average}{
\itemize{
\item \code{Clustering} the name of the clustering.
\item \code{Cluster} the name of the cluster.
\item \verb{ATC Groups} the name of the ATC group. The groups are given by the
\code{atc_groups} input.
\item \emph{timing variables} the average timing value in the ATC group and cluster.
\item \verb{Number of Medications} the number of medications in the ATC group in
the cluster.
\item \verb{Percentage of Medications} the percentage of medication in the cluster
with this ATC group.
\item \verb{Number of Distinct Timing Trajectories} the number of unique timing
trajectories in the ATC group in the cluster.
}
}

\subsection{individual}{
\itemize{
\item \code{Clustering} the name of the clustering.
\item \code{Cluster} the name of the cluster.
\item \emph{timing variables} a unique timing pattern in the ATC group and cluster.
\item \verb{Number of Medications with Timing Trajectory} the number of medications
with this unique timing trajectory and ATC group.
}
}
}
\description{
The function \code{timing_atc_group()} calculates the frequencies of distinct
timing and ATC combinations within clusters.
}
\details{
\code{timing_atc_group()} calculates both the number of people with unique timing
trajectory and ATC group, as given by \code{atc_groups}, in each cluster.
}
\examples{
clust <- medic(
  complications,
  id = id,
  atc = atc,
  k = 3:5,
  timing = first_trimester:third_trimester
)

timing_atc_group(clust, k == 5, clusters = I:III)

}
