% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof_tapnet.R
\name{gof_tapnet}
\alias{gof_tapnet}
\title{Goodness-of-fit of a tapnet fit}
\usage{
gof_tapnet(
  fit,
  tapnet = NULL,
  indices = c("connectance", "NODF", "weighted NODF", "H2"),
  nrep = 1000,
  se_refit = FALSE,
  se_nsim = 1000
)
}
\arguments{
\item{fit}{results of applying fit_tapnet to the tapnet object;}

\item{tapnet}{a tapnet object created with simulate_tapnet or make_tapnet; if NULL, the name stored in the attributes of fit is used to access an object of that name in the global environment; can be used e.g. in simulations, when the tapnet object is renamed relative to the one fitted;}

\item{indices}{network indices to compare between observed and fitted network; calls \code{\link[bipartite]{networklevel}};}

\item{nrep}{Number of networks to simulate for indices comparison; these are draws from the fitted multinomial distribution;}

\item{se_refit}{logical; should standard errors for the parameters be calculated using parametric bootstrap (refitting on simulated data)? Defaults to FALSE because it's very slow (i.e. takes hours).}

\item{se_nsim}{number of simulations for parametric bootstrap (ignored unless the previous argument is set to TRUE).}
}
\value{
A list of goodness-of-fit measures: bc_sim_web are the Bray-Curtis similarities between fitted and observed network; cor_web are Spearman correlations between fitted and observed; and net_indices compute the selected network indices for fitted and observed networks. If more than one network is used for fitting, all these measures are returned for all networks (as vector or list under the respective label). See example.
}
\description{
Provides various measures to describe how well the tapnet model fits the data
}
\details{
This is a function particularly interesting for simulated data, when the true parameters are known. In this case, GOF for fitted latent traits and so forth are computed.
}
\examples{
\donttest{
  data(Tinoco)
  tap <- make_tapnet(tree_low = plant_tree, tree_high = humm_tree, networks = networks[2:3], 
         traits_low = plant_traits, traits_high = humm_traits, npems_lat = 4)
  fit <- fit_tapnet(tap) # uses networks 2 and 3 for fitting!
  gof_tapnet(fit)
}

}
\references{
Benadi et al. in prep
}
\author{
Gita Benadi <gita.benadi@biom.uni-freiburg.de> and Carsten Dormann <carsten.dormann@biom.uni-freiburg.de>
}
