% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tapnet2df.R
\name{tapnet2df}
\alias{tapnet2df}
\title{Convert tapnet object into data.frame}
\usage{
tapnet2df(tapnetObject)
}
\arguments{
\item{tapnetObject}{results of applying fit_tapnet to the tapnet object;}
}
\value{
A data.frame containing network observations, PEMs, traits and abundances for regression-type analysis.
}
\description{
Function allows direct use of data prepared for tapnet analysis by other statistical methods, e.g. regression approaches
}
\details{
This function simply puts all data into a data.frame, with each row an entry in the network matrix.
}
\examples{
ex <- simulate_tapnet(nlower=10, nhigher=50, ntraits_pem=3, ntraits_nopem=2, Nwebs = 3)
df <- tapnet2df(ex)
head(df)
\dontrun{
  library(ranger)
  frf <- ranger(interactions ~ ., data=df[, -c(1:2)], importance="impurity")
  sort(importance(frf), decreasing=TRUE)
}

}
\references{
Benadi et al. in prep
}
\author{
Carsten Dormann <carsten.dormann@biom.uni-freiburg.de>
}
