% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa_at.R
\name{taxa_at}
\alias{taxa_at}
\title{Get taxa at specific scientific ranks}
\usage{
taxa_at(
  x,
  rank,
  db = "ncbi",
  missing = "lower",
  verbose = TRUE,
  warn = TRUE,
  ...
)
}
\arguments{
\item{x}{(character) Vector of taxon keys (ids) for the given
database. required}

\item{rank}{(character) A target rank for which to fetch data. required}

\item{db}{(character) The database to search, one of ncbi, itis, gbif,
col, or wfo}

\item{missing}{(character) if no data found at the given rank and input key,
should we get the next closest lower than that given in \code{rank}, or higher.
one of lower (default), higher.}

\item{verbose}{(logical) Print verbose messages}

\item{warn}{(logical) If \code{TRUE}, raise a warning if any taxon IDs can not
be found}

\item{...}{Additional arguments passed to database specific classification
functions}
}
\value{
list of data.frame's for each input taxon key, where each data.frame
has fields: name, rank, id. When no results found, an empty data.frame
}
\description{
Get taxa at specific scientific ranks
}
\examples{
\dontrun{
taxa_at(186803, rank = "order", db = "ncbi", missing = "lower")
taxa_at(c(186803, 541000, 216572, 186804, 31979,  186806),
 rank = "family", missing = "lower")
taxa_at(c(154395, 154357, 23041, 154396), rank = "family", db="itis")
taxa_at(c('wfo-4000032377', 'wfo-0000541830'), rank = "family", db = "wfo")
taxa_at("wfo-7000000057", rank = "order", db = "wfo")
taxa_at(2877951, rank = "phylum", db = "gbif")
taxa_at(c(2877951, 5386), rank = "family", db = "gbif")
taxa_at(c("C66T4", "C7ZVH", "TP"), rank = "family", db = "col")
}
}
