% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_scientific.R
\name{check_scientific}
\alias{check_scientific}
\title{Parse and resolve a scientific name string}
\usage{
check_scientific(name)
}
\arguments{
\item{name}{scientific name string to be checked}
}
\value{
Resolved canonical name (NULL if not matched)
}
\description{
Parse the name using Global Names Resolver 'GNR' and Global Biodiversity
 Information Facility 'GBIF' parse API to make sure the name is scientific
 name
}
\examples{
\donttest{
check_scientific("Akodon longipilis (Waterhouse, 1837)")
check_scientific("Mus longipilis Waterhouse, 1837")
check_scientific("Akodon hershkovitzi Patterson, Gallardo, and Freas, 1984")
}
}
\seealso{
Other Name functions: 
\code{\link{build_gen_syn}()},
\code{\link{cast_canonical}()},
\code{\link{cast_scientificname}()},
\code{\link{expand_name}()},
\code{\link{get_accepted_names}()},
\code{\link{guess_taxo_rank}()},
\code{\link{list_higher_taxo}()},
\code{\link{melt_canonical}()},
\code{\link{melt_scientificname}()},
\code{\link{resolve_names}()},
\code{\link{taxo_fuzzy_match}()}
}
\concept{Name functions}
