% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{circle_mean_diff}
\alias{circle_mean_diff}
\alias{circular_mean_difference}
\alias{circular_mean_difference_alt}
\title{Circular Mean Difference}
\usage{
circular_mean_difference(x, w = NULL, axial = TRUE, na.rm = TRUE)

circular_mean_difference_alt(x, w = NULL, axial = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{numeric vector. Values in degrees.}

\item{w}{(optional) Weights. A vector of positive numbers and of the same
length as \code{x}.}

\item{axial}{logical. Whether the data are axial, i.e. pi-periodical
(\code{TRUE}, the default) or directional, i.e. \eqn{2 \pi}-periodical (\code{FALSE}).}

\item{na.rm}{logical value indicating whether \code{NA} values in \code{x}
should be stripped before the computation proceeds.}
}
\value{
numeric
}
\description{
The circular mean difference is based on the sample circular distance
}
\examples{
data("san_andreas")
circular_mean_difference(san_andreas$azi)
circular_mean_difference(san_andreas$azi, weighting(san_andreas$unc))

circular_mean_difference_alt(san_andreas$azi)
circular_mean_difference_alt(san_andreas$azi, weighting(san_andreas$unc))
}
\references{
Mardia, K.V., and Jupp, P.E (1999). Directional Statistics,
Wiley Series in Probability and Statistics. John Wiley & Sons, Inc.,
Hoboken, NJ, USA. \doi{10.1002/9780470316979}
}
\seealso{
\code{\link[=sample_circular_distance]{sample_circular_distance()}}
}
