% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_car_speed.R
\name{gg_car_speed_histogram}
\alias{gg_car_speed_histogram}
\title{Histogram of car speed over a period, for a segment or a subset of segment.}
\usage{
gg_car_speed_histogram(
  enriched_data,
  date_range = NULL,
  segments = NULL,
  weekday = NULL,
  hours = NULL,
  aggregated_by = NULL
)
}
\arguments{
\item{enriched_data}{enriched data.frame containing all the data for all your sensors}

\item{date_range}{Date vector. Example: c('2021-01-01','2022-01-01'). Full period if NULL (default).}

\item{segments}{Character vector. Selected road segment, all if NULL (default).}

\item{weekday}{Character vector. Weekday choosen. Default to the all week.}

\item{hours}{Integer vector. Hours choosen, default to the all day.}

\item{aggregated_by}{Character. Enables comparison with other segments or weekdays. Options are : 'segment_name', 'weekday', NULL (no comparison, default).}
}
\value{
Graph showing histogram of car speed over a period.
}
\description{
Histogram of car speed over a period, for a segment or a subset of segment.
}
\examples{
library(dplyr)
subset_traffic <- traffic \%>\% filter(day < '2022-02-01', hour > 9)
gg_car_speed_histogram(subset_traffic)
gg_car_speed_histogram(subset_traffic,
  aggregated_by = 'segment_name')
gg_car_speed_histogram(subset_traffic,
  weekday = c('monday','sunday'),
  segments = 'RteVitre-06',
  hours = 17:20,
  aggregated_by = "weekday")
}
