% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_car_speed.R
\name{preprocess_car_speed}
\alias{preprocess_car_speed}
\title{Preprocessing mandatory for car speed graphs functions}
\usage{
preprocess_car_speed(
  enriched_data,
  aggregated_by,
  date_range,
  segments,
  weekday,
  hours
)
}
\arguments{
\item{enriched_data}{enriched data.frame containing all the data for all your sensors}

\item{aggregated_by}{Character. Enables comparison with other segments or weekdays. Options are : 'segment_name', 'weekday'.}

\item{date_range}{Date vector. Example: c('2021-01-01','2022-01-01').}

\item{segments}{Character vector. Selected road segment.}

\item{weekday}{Character vector. Weekday choosen.}

\item{hours}{Integer vector. Hours choosen.}
}
\value{
list of parameters and data preprocessed.
}
\description{
Preprocessing mandatory for car speed graphs functions
}
\examples{
preprocess_car_speed(traffic,
  date_range = c('2022-01-01','2022-03-01'),
  segments = 'RteVitre-06',
  weekday = c('monday','sunday'),
  hours = 17:20,
  aggregated_by = "weekday")

}
\keyword{internal}
