% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TEMPTED.R
\name{reconstruct}
\alias{reconstruct}
\title{Reconstruct tensor from low dimensional components}
\usage{
reconstruct(res_tempted, res_svd = NULL, datlist = NULL, r_reconstruct = NULL)
}
\arguments{
\item{res_tempted}{Output of function \code{\link{tempted}}.}

\item{res_svd}{Output of function \code{\link{svd_centralize}} if mean subtraction \code{\link{svd_centralize}} was performed before \code{\link{tempted}}. If mean subtraction was not performed, specify \code{res_svd=NULL} and provide \code{datlist}.}

\item{datlist}{Output of function \code{\link{format_tempted}} if mean subtraction was not performed and \code{res_svd=NULL}, or left as \code{NULL} if mean subtraction was performed and \code{res_svd} is provided.}

\item{r_reconstruct}{The number of components from TEMPTED to be used for the tensor reconstruction.}
}
\value{
datlist_est The reconstructed tensor stored in a datlist format same as the output of \code{\link{format_tempted}}.
}
\description{
This function reconstructs the temporal tensor from the low dimensional components extracted by \code{\link{tempted}} and \code{\link{svd_centralize}}.
}
\examples{
# Take a subset of the samples so the example runs faster

# Here we are taking samples from the odd months
sub_sample <- rownames(meta_table)[(meta_table$day_of_life\%/\%12)\%\%2==1]
count_table_sub <- count_table[sub_sample,]
processed_table_sub <- processed_table[sub_sample,]
meta_table_sub <- meta_table[sub_sample,]
# reconstruct with mean subtraction
datlist <- format_tempted(processed_table_sub,
                          meta_table_sub$day_of_life,
                          meta_table_sub$studyid,
                          pseudo=NULL,
                          transform="none")

mean_svd <- svd_centralize(datlist, r=1)

res_tempted <- tempted(mean_svd$datlist, r=2, smooth=1e-5)

datlist_est <- reconstruct(res_tempted, mean_svd, datlist=NULL, r_reconstruct=2)
vec_est <- unlist(sapply(datlist_est, function(x){x[-1,]}))
vec_obs <- unlist(sapply(datlist, function(x){x[-1,]}))
R2 <- 1-sum((vec_est-vec_obs)^2)/sum(vec_obs^2)
R2

# reconstruct without mean subtraction
datlist <- format_tempted(processed_table_sub,
                          meta_table_sub$day_of_life,
                          meta_table_sub$studyid,
                          pseudo=NULL,
                          transform="none")

res_tempted <- tempted(datlist, r=2, smooth=1e-5)

datlist_est <- reconstruct(res_tempted, res_svd=NULL, datlist=datlist, r_reconstruct=2)
vec_est <- unlist(sapply(datlist_est, function(x){x[-1,]}))
vec_obs <- unlist(sapply(datlist, function(x){x[-1,]}))
R2 <- 1-sum((vec_est-vec_obs)^2)/sum(vec_obs^2)
R2

}
