% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hoff_functions.R
\name{Kom}
\alias{Kom}
\title{Commutation matrix.}
\usage{
Kom(m, n)
}
\arguments{
\item{m}{a natural number.}

\item{n}{another natural number.}
}
\value{
\code{K} The \code{m * n} by \code{m * n} commutation
    matrix.
}
\description{
Construct the communtation matrix.
}
\details{
This function constructs the commutation matrix \code{K}, which maps
\code{c(A)} to \code{c(t(A))} for an \eqn{m} by \eqn{n} matrix
\code{A}.
}
\examples{
m <- 5 ; n <- 4
A <- matrix(stats::rnorm(m * n), m, n)
Kom(5, 4) \%*\% c(A) - c(t(A))
}
\references{
\itemize{
  \item{Magnus, J. R., & Neudecker, H. (1979). The commutation matrix: some properties and applications. \emph{The Annals of Statistics}, 381-394. \doi{10.1214/aos/1176344621}}
  \item{Tracy, D. S., & Dwyer, P. S. (1969). Multivariate maxima and minima with matrix derivatives. \emph{Journal of the American Statistical Association}, 64(328), 1576-1594. \doi{10.1080/01621459.1969.10501078}}
}
}
\author{
Peter Hoff.
}
