% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sparse_Sums}
\alias{sparse_Sums}
\title{RowSums and colSums for a sparse matrix}
\usage{
sparse_Sums(sparse_matrix, rowSums = FALSE)
}
\arguments{
\item{sparse_matrix}{a sparse matrix}

\item{rowSums}{either TRUE or FALSE. If TRUE then the row-sums will be calculated, otherwise the column-sums}
}
\value{
a vector with either the row- or the column-sums of the matrix
}
\description{
RowSums and colSums for a sparse matrix
}
\examples{

library(textTinyR)

tmp = matrix(sample(0:1, 100, replace = TRUE), 10, 10)

sp_mat = dense_2sparse(tmp)

spsm = sparse_Sums(sp_mat, rowSums = FALSE)
}
