% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.table.R
\name{rm_long_words}
\alias{rm_long_words}
\title{Delete rows in a text.table where the word has more than a minimum number of characters}
\usage{
rm_long_words(x, text, max_char_length)
}
\arguments{
\item{x}{A text.table created by as.text.table().}

\item{text}{A string, the name of the column in x used to determine deletion of rows based on the number of characters.}

\item{max_char_length}{A number, the maximum number of characters allowed to not delete a row.}
}
\value{
A text.table, with rows having more than a certain number of characters deleted.
}
\description{
Delete rows in a text.table where the word has more than a minimum number of characters
}
\examples{
rm_long_words(
as.text.table(
  x = as.data.table(
    list(
      col1 = c(
        "a",
        "b"
      ),
      col2 = c(
        tolower("The dog is nice because it picked up the newspaper."),
        tolower("The dog is extremely nice because it does the dishes.")
      )
    )
  ),
  text = "col2",
  split = " "
),
text = "col2",
max_char_length = 4
)
}
