% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_ops.R
\name{crf_log_likelihood}
\alias{crf_log_likelihood}
\title{CRF log likelihood}
\usage{
crf_log_likelihood(
  inputs,
  tag_indices,
  sequence_lengths,
  transition_params = NULL
)
}
\arguments{
\item{inputs}{A [batch_size, max_seq_len, num_tags] tensor of unary potentials to use
as input to the CRF layer.}

\item{tag_indices}{A [batch_size, max_seq_len] matrix of tag indices for which we
compute the log-likelihood.}

\item{sequence_lengths}{A [batch_size] vector of true sequence lengths.}

\item{transition_params}{A [num_tags, num_tags] transition matrix, if available.}
}
\value{
log_likelihood: A [batch_size] Tensor containing the log-likelihood of each example,
given the sequence of tag indices. transition_params: A [num_tags, num_tags] transition matrix.
This is either provided by the caller or created in this function.
}
\description{
Computes the log-likelihood of tag sequences in a CRF.
}
