% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_ops.R
\name{img_interpolate_bilinear}
\alias{img_interpolate_bilinear}
\title{Interpolate bilinear}
\usage{
img_interpolate_bilinear(grid, query_points, indexing = "ij", name = NULL)
}
\arguments{
\item{grid}{a 4-D float Tensor of shape [batch, height, width, channels].}

\item{query_points}{a 3-D float Tensor of N points with shape [batch, N, 2].}

\item{indexing}{whether the query points are specified as row and column (ij),
or Cartesian coordinates (xy).}

\item{name}{a name for the operation (optional).}
}
\value{
values: a 3-D `Tensor` with shape `[batch, N, channels]`
}
\description{
Similar to Matlab's interp2 function.
}
\details{
Finds values for query points on a grid using bilinear interpolation.
}
\section{Raises}{

ValueError: if the indexing mode is invalid, or if the shape of the inputs invalid.
}

